/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortUnaryOperator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.ArmorSlot;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IHasExtraData;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.slot.OffhandSlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBlockPos;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableByteArray;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloat;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.sync.SyncableShort;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.container.sync.chemical.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.chemical.SyncablePigmentStack;
import mekanism.common.inventory.container.sync.chemical.SyncableSlurryStack;
import mekanism.common.inventory.container.sync.list.SyncableCollection;
import mekanism.common.inventory.container.sync.list.SyncableList;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.container.PacketUpdateContainer;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_server.PacketWindowSelect;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MekanismContainer
extends AbstractContainerMenu
implements ISecurityContainer {
    public static final int BASE_Y_OFFSET = 84;
    public static final int TRANSPORTER_CONFIG_WINDOW = 0;
    public static final int SIDE_CONFIG_WINDOW = 1;
    public static final int UPGRADE_WINDOW = 2;
    public static final int SKIN_SELECT_WINDOW = 3;
    protected final Inventory inv;
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<ArmorSlot> armorSlots = new ArrayList<ArmorSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    protected final List<OffhandSlot> offhandSlots = new ArrayList<OffhandSlot>();
    private final List<ISyncableData> trackedData = new ArrayList<ISyncableData>();
    private final Map<Object, List<ISyncableData>> specificTrackedData = new Object2ObjectOpenHashMap();
    @Nullable
    protected SelectedWindowData selectedWindow;
    private Map<UUID, SelectedWindowData> selectedWindows;

    protected MekanismContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv) {
        super((MenuType)type.get(), id);
        this.inv = inv;
        if (!this.getLevel().isClientSide()) {
            this.selectedWindows = new HashMap<UUID, SelectedWindowData>(1);
        }
    }

    public UUID getPlayerUUID() {
        return this.inv.player.getUUID();
    }

    public Level getLevel() {
        return this.inv.player.level();
    }

    @NotNull
    protected Slot addSlot(@NotNull Slot slot) {
        super.addSlot(slot);
        if (slot instanceof IHasExtraData) {
            IHasExtraData hasExtraData = (IHasExtraData)slot;
            hasExtraData.addTrackers(this.inv.player, this::track);
        }
        if (slot instanceof InventoryContainerSlot) {
            InventoryContainerSlot inventorySlot = (InventoryContainerSlot)slot;
            this.inventoryContainerSlots.add(inventorySlot);
        } else if (slot instanceof ArmorSlot) {
            ArmorSlot armorSlot = (ArmorSlot)slot;
            this.armorSlots.add(armorSlot);
        } else if (slot instanceof MainInventorySlot) {
            MainInventorySlot inventorySlot = (MainInventorySlot)slot;
            this.mainInventorySlots.add(inventorySlot);
        } else if (slot instanceof HotBarSlot) {
            HotBarSlot hotBarSlot = (HotBarSlot)slot;
            this.hotBarSlots.add(hotBarSlot);
        } else if (slot instanceof OffhandSlot) {
            OffhandSlot offhandSlot = (OffhandSlot)slot;
            this.offhandSlots.add(offhandSlot);
        }
        return slot;
    }

    protected void addSlotsAndOpen() {
        this.addSlots();
        this.addInventorySlots(this.inv);
        this.openInventory(this.inv);
    }

    public void startTrackingServer(Object key, ISpecificContainerTracker tracker) {
        int currentSize = this.trackedData.size();
        List<ISyncableData> list = this.startTracking(key, tracker);
        this.sendInitialDataToRemote(list, index -> (short)(index + currentSize));
    }

    public List<ISyncableData> startTracking(Object key, ISpecificContainerTracker tracker) {
        List<ISyncableData> list = tracker.getSpecificSyncableData();
        for (ISyncableData data : list) {
            this.track(data);
        }
        this.specificTrackedData.put(key, list);
        return list;
    }

    public void stopTracking(Object key) {
        List<ISyncableData> list = this.specificTrackedData.remove(key);
        if (list != null) {
            this.trackedData.removeAll(list);
        }
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, @NotNull Slot slot) {
        if (slot instanceof IInsertableSlot) {
            IInsertableSlot insertableSlot = (IInsertableSlot)slot;
            if (!insertableSlot.canMergeWith(stack)) {
                return false;
            }
            SelectedWindowData selectedWindow = this.getLevel().isClientSide() ? this.getSelectedWindow() : this.getSelectedWindow(this.getPlayerUUID());
            return insertableSlot.exists(selectedWindow) && super.canTakeItemForPickAll(stack, slot);
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.closeInventory(player);
    }

    protected void closeInventory(@NotNull Player player) {
        if (!player.level().isClientSide()) {
            this.clearSelectedWindow(player.getUUID());
        }
    }

    protected void openInventory(@NotNull Inventory inv) {
    }

    protected int getInventoryYOffset() {
        return 84;
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected void addInventorySlots(@NotNull Inventory inv) {
        if (this instanceof IEmptyContainer) {
            return;
        }
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.addSlot(new MainInventorySlot((Container)inv, Inventory.getSelectionSize() + slotX + slotY * 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (int slotX = 0; slotX < Inventory.getSelectionSize(); ++slotX) {
            this.addSlot(this.createHotBarSlot(inv, slotX, xOffset + slotX * 18, yOffset));
        }
    }

    protected void addArmorSlots(@NotNull Inventory inv, int x, int y, int offhandOffset) {
        for (int index = 0; index < inv.armor.size(); ++index) {
            EquipmentSlot slotType = EnumUtils.EQUIPMENT_SLOT_TYPES[2 + inv.armor.size() - index - 1];
            this.addSlot(new ArmorSlot(inv, 36 + inv.armor.size() - index - 1, x, y, slotType));
            y += 18;
        }
        if (offhandOffset != -1) {
            this.addSlot(new OffhandSlot((Container)inv, 40, x, y + offhandOffset, inv.player));
        }
    }

    protected HotBarSlot createHotBarSlot(@NotNull Inventory inv, int index, int x, int y) {
        return new HotBarSlot((Container)inv, index, x, y);
    }

    protected void addSlots() {
    }

    public List<InventoryContainerSlot> getInventoryContainerSlots() {
        return Collections.unmodifiableList(this.inventoryContainerSlots);
    }

    public List<MainInventorySlot> getMainInventorySlots() {
        return Collections.unmodifiableList(this.mainInventorySlots);
    }

    public List<HotBarSlot> getHotBarSlots() {
        return Collections.unmodifiableList(this.hotBarSlots);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotID) {
        ItemStack slotStack;
        IInsertableSlot insertableSlot;
        SelectedWindowData selectedWindow;
        Slot currentSlot = (Slot)this.slots.get(slotID);
        if (currentSlot == null || !currentSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        SelectedWindowData selectedWindowData = selectedWindow = player.level().isClientSide ? this.getSelectedWindow() : this.getSelectedWindow(player.getUUID());
        if (currentSlot instanceof IInsertableSlot && !(insertableSlot = (IInsertableSlot)currentSlot).exists(selectedWindow)) {
            return ItemStack.EMPTY;
        }
        ItemStack stackToInsert = slotStack = currentSlot.getItem();
        if (currentSlot instanceof InventoryContainerSlot) {
            if (slotStack.getCount() > slotStack.getMaxStackSize()) {
                stackToInsert = slotStack = slotStack.copyWithCount(slotStack.getMaxStackSize());
            }
            stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, false, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, false, selectedWindow);
        } else {
            stackToInsert = MekanismContainer.insertItem(this.inventoryContainerSlots, stackToInsert, true, selectedWindow);
            if (slotStack.getCount() == stackToInsert.getCount()) {
                stackToInsert = MekanismContainer.insertItem(this.inventoryContainerSlots, stackToInsert, false, selectedWindow);
                if (slotStack.getCount() == stackToInsert.getCount()) {
                    if (currentSlot instanceof ArmorSlot || currentSlot instanceof OffhandSlot) {
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, true, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, true, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, false, selectedWindow);
                    } else if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, selectedWindow);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, selectedWindow);
                    }
                }
            }
        }
        if (stackToInsert.getCount() == slotStack.getCount()) {
            return ItemStack.EMPTY;
        }
        return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, @Nullable SelectedWindowData selectedWindow) {
        stack = MekanismContainer.insertItem(slots, stack, true, selectedWindow);
        return MekanismContainer.insertItem(slots, stack, false, selectedWindow);
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty, @Nullable SelectedWindowData selectedWindow) {
        return MekanismContainer.insertItem(slots, stack, ignoreEmpty, selectedWindow, Action.EXECUTE);
    }

    @NotNull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty, @Nullable SelectedWindowData selectedWindow, Action action) {
        return MekanismContainer.insertItem(slots, stack, ignoreEmpty, false, selectedWindow, action);
    }

    @NotNull
    public static <SLOT extends Slot> ItemStack insertItemCheckAll(List<SLOT> slots, @NotNull ItemStack stack, @Nullable SelectedWindowData selectedWindow, Action action) {
        return MekanismContainer.insertItem(slots, stack, false, true, selectedWindow, action);
    }

    @NotNull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty, boolean checkAll, @Nullable SelectedWindowData selectedWindow, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        for (Slot slot : slots) {
            if (!checkAll && ignoreEmpty != slot.hasItem() || !((IInsertableSlot)slot).exists(selectedWindow) || !(stack = ((IInsertableSlot)slot).insertItem(stack, action)).isEmpty()) continue;
            break;
        }
        return stack;
    }

    @NotNull
    protected ItemStack transferSuccess(@NotNull Slot currentSlot, @NotNull Player player, @NotNull ItemStack slotStack, @NotNull ItemStack stackToInsert) {
        int difference = slotStack.getCount() - stackToInsert.getCount();
        ItemStack newStack = currentSlot.remove(difference);
        currentSlot.onTake(player, newStack);
        return newStack;
    }

    @Nullable
    public SelectedWindowData getSelectedWindow() {
        return this.selectedWindow;
    }

    @Nullable
    public SelectedWindowData getSelectedWindow(UUID player) {
        return this.selectedWindows.get(player);
    }

    public void setSelectedWindow(@Nullable SelectedWindowData selectedWindow) {
        if (!Objects.equals(this.selectedWindow, selectedWindow)) {
            this.selectedWindow = selectedWindow;
            PacketUtils.sendToServer(new PacketWindowSelect(this.selectedWindow));
        }
    }

    public void setSelectedWindow(UUID player, @Nullable SelectedWindowData selectedWindow) {
        if (selectedWindow == null) {
            this.clearSelectedWindow(player);
        } else {
            this.selectedWindows.put(player, selectedWindow);
        }
    }

    private void clearSelectedWindow(UUID player) {
        this.selectedWindows.remove(player);
    }

    public void track(ISyncableData data) {
        this.trackedData.add(data);
    }

    @NotNull
    protected DataSlot addDataSlot(@NotNull DataSlot referenceHolder) {
        this.track(SyncableInt.create(() -> ((DataSlot)referenceHolder).get(), arg_0 -> ((DataSlot)referenceHolder).set(arg_0)));
        return referenceHolder;
    }

    public void trackArray(boolean[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableBoolean.create(arrayIn, i));
        }
    }

    public void trackArray(byte[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableByte.create(arrayIn, i));
        }
    }

    public void trackArray(double[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableDouble.create(arrayIn, i));
        }
    }

    public void trackArray(float[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableFloat.create(arrayIn, i));
        }
    }

    public void trackArray(int[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableInt.create(arrayIn, i));
        }
    }

    public void trackArray(long[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableLong.create(arrayIn, i));
        }
    }

    public void trackArray(short[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableShort.create(arrayIn, i));
        }
    }

    public void trackArray(boolean[][] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            for (int j = 0; j < arrayIn[i].length; ++j) {
                this.track(SyncableBoolean.create(arrayIn, i, j));
            }
        }
    }

    @Nullable
    private ISyncableData getTrackedData(short property) {
        if (property >= 0 && property < this.trackedData.size()) {
            return this.trackedData.get(property);
        }
        Mekanism.logger.warn("Received out of bounds window property {} for container {}. There are currently {} tracked properties.", new Object[]{property, RegistryUtils.getName(this.getType()), this.trackedData.size()});
        return null;
    }

    public void handleWindowProperty(short property, boolean value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableBoolean) {
            SyncableBoolean syncable = (SyncableBoolean)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, byte value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableByte) {
            SyncableByte syncable = (SyncableByte)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, short value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableShort) {
            SyncableShort syncable = (SyncableShort)data;
            syncable.set(value);
        } else if (data instanceof SyncableFloatingLong) {
            SyncableFloatingLong syncable = (SyncableFloatingLong)data;
            syncable.setDecimal(value);
        }
    }

    public void handleWindowProperty(short property, int value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableInt) {
            SyncableInt syncable = (SyncableInt)data;
            syncable.set(value);
        } else if (data instanceof SyncableEnum) {
            SyncableEnum syncable = (SyncableEnum)data;
            syncable.set(value);
        } else if (data instanceof SyncableFluidStack) {
            SyncableFluidStack syncable = (SyncableFluidStack)data;
            syncable.set(value);
        } else if (data instanceof SyncableItemStack) {
            SyncableItemStack syncable = (SyncableItemStack)data;
            syncable.set(value);
        } else if (data instanceof SyncableRegistryEntry) {
            SyncableRegistryEntry syncable = (SyncableRegistryEntry)data;
            syncable.setFromId(value);
        }
    }

    public void handleWindowProperty(short property, long value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableLong) {
            SyncableLong syncable = (SyncableLong)data;
            syncable.set(value);
        } else if (data instanceof SyncableChemicalStack) {
            SyncableChemicalStack syncable = (SyncableChemicalStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, float value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableFloat) {
            SyncableFloat syncable = (SyncableFloat)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, double value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableDouble) {
            SyncableDouble syncable = (SyncableDouble)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, @NotNull ItemStack value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableItemStack) {
            SyncableItemStack syncable = (SyncableItemStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, @NotNull FluidStack value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableFluidStack) {
            SyncableFluidStack syncable = (SyncableFluidStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, @Nullable BlockPos value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableBlockPos) {
            SyncableBlockPos syncable = (SyncableBlockPos)data;
            syncable.set(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <STACK extends ChemicalStack<?>> void handleWindowProperty(short property, @NotNull STACK value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableGasStack) {
            SyncableGasStack syncable = (SyncableGasStack)data;
            if (value instanceof GasStack) {
                GasStack stack = (GasStack)value;
                syncable.set(stack);
                return;
            }
        }
        if (data instanceof SyncableInfusionStack) {
            SyncableInfusionStack syncable = (SyncableInfusionStack)data;
            if (value instanceof InfusionStack) {
                InfusionStack stack = (InfusionStack)value;
                syncable.set(stack);
                return;
            }
        }
        if (data instanceof SyncablePigmentStack) {
            SyncablePigmentStack syncable = (SyncablePigmentStack)data;
            if (value instanceof PigmentStack) {
                PigmentStack stack = (PigmentStack)value;
                syncable.set(stack);
                return;
            }
        }
        if (!(data instanceof SyncableSlurryStack)) return;
        SyncableSlurryStack syncable = (SyncableSlurryStack)data;
        if (!(value instanceof SlurryStack)) return;
        SlurryStack stack = (SlurryStack)value;
        syncable.set(stack);
    }

    public void handleWindowProperty(short property, byte[] value) {
        ISyncableData data;
        ISyncableData iSyncableData = data = this.getTrackedData(property);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SyncableByteArray.class, SyncableFrequency.class, SyncableList.class, SyncableCollection.class}, (Object)iSyncableData, n)) {
            case 0: {
                SyncableByteArray syncable = (SyncableByteArray)iSyncableData;
                syncable.set(value);
                break;
            }
            case 1: {
                SyncableFrequency syncable = (SyncableFrequency)iSyncableData;
                syncable.set(this.getLevel().registryAccess(), value);
                break;
            }
            case 2: {
                SyncableList syncable = (SyncableList)iSyncableData;
                syncable.set(this.getLevel().registryAccess(), value);
                break;
            }
            case 3: {
                SyncableCollection syncable = (SyncableCollection)iSyncableData;
                syncable.set(this.getLevel().registryAccess(), value);
                break;
            }
            default: {
                Mekanism.logger.error("Unknown byte value type: {}, please report", data == null ? null : data.getClass().getName());
            }
        }
    }

    public void handleWindowProperty(short property, @NotNull FloatingLong value) {
        ISyncableData data = this.getTrackedData(property);
        if (data instanceof SyncableFloatingLong) {
            SyncableFloatingLong syncable = (SyncableFloatingLong)data;
            syncable.set(value);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.inv.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            RegistryAccess registryAccess = player2.level().registryAccess();
            for (short i = 0; i < this.trackedData.size(); i = (short)((short)(i + 1))) {
                ISyncableData data = this.trackedData.get(i);
                ISyncableData.DirtyType dirtyType = data.isDirty();
                if (dirtyType == ISyncableData.DirtyType.CLEAN) continue;
                dirtyData.add(data.getPropertyData(registryAccess, i, dirtyType));
            }
            if (!dirtyData.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PacketUpdateContainer((short)this.containerId, dirtyData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        this.sendInitialDataToRemote(this.trackedData, ShortUnaryOperator.identity());
    }

    private void sendInitialDataToRemote(List<ISyncableData> syncableData, ShortUnaryOperator propertyIndex) {
        Player player = this.inv.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            RegistryAccess registryAccess = player2.level().registryAccess();
            for (short i = 0; i < syncableData.size(); i = (short)(i + 1)) {
                ISyncableData data = syncableData.get(i);
                data.isDirty();
                dirtyData.add(data.getPropertyData(registryAccess, propertyIndex.apply(i), ISyncableData.DirtyType.DIRTY));
            }
            if (!dirtyData.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PacketUpdateContainer((short)this.containerId, dirtyData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static interface ISpecificContainerTracker {
        public List<ISyncableData> getSpecificSyncableData();
    }
}

