/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class TypedMekanismRecipeMapper<RECIPE extends Recipe<?>>
implements IRecipeTypeMapper {
    private final Holder<RecipeType<?>>[] supportedTypes;
    private final Class<RECIPE> recipeClass;

    @SafeVarargs
    protected TypedMekanismRecipeMapper(Class<RECIPE> recipeClass, DeferredHolder<RecipeType<?>, ? extends RecipeType<? extends RECIPE>> ... supportedTypes) {
        this.supportedTypes = supportedTypes;
        this.recipeClass = recipeClass;
    }

    public final boolean canHandle(RecipeType<?> recipeType) {
        for (Holder<RecipeType<?>> supportedType : this.supportedTypes) {
            if (supportedType.value() != recipeType) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> var1, RECIPE var2);

    public final boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RecipeHolder<?> recipeHolder, RegistryAccess registryAccess, INSSFakeGroupManager groupManager) {
        Recipe recipe = recipeHolder.value();
        if (this.recipeClass.isInstance(recipe)) {
            return this.handleRecipe(mapper, (Recipe)this.recipeClass.cast(recipe));
        }
        return false;
    }
}

