/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

@RecipeTypeMapper
public class SawmillRecipeMapper
extends TypedMekanismRecipeMapper<SawmillRecipe> {
    public SawmillRecipeMapper() {
        super(SawmillRecipe.class, MekanismRecipeType.SAWING);
    }

    public String getName() {
        return "MekSawmill";
    }

    public String getDescription() {
        return "Maps Mekanism sawmill recipes. (Disabled by default, due to causing various EMC values to be removed pertaining to charcoal/wood)";
    }

    public boolean isAvailable() {
        return false;
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, SawmillRecipe recipe) {
        ItemStackIngredient input = recipe.getInput();
        int primaryMultiplier = 1;
        int secondaryMultiplier = 1;
        if (recipe.getSecondaryChance() > 0.0 && recipe.getSecondaryChance() < 1.0) {
            Fraction multiplier;
            try {
                multiplier = Fraction.getFraction((double)recipe.getSecondaryChance()).invert();
            }
            catch (ArithmeticException e) {
                return false;
            }
            primaryMultiplier = multiplier.getNumerator();
            secondaryMultiplier = multiplier.getDenominator();
        }
        boolean handled = false;
        for (ItemStack representation : input.getRepresentations()) {
            SawmillRecipe.ChanceOutput output = recipe.getOutput(representation);
            ItemStack mainOutput = output.getMainOutput();
            ItemStack secondaryOutput = output.getMaxSecondaryOutput();
            NSSItem nssInput = NSSItem.createItem((ItemStack)representation);
            IngredientHelper ingredientHelper = new IngredientHelper(mapper);
            if (secondaryOutput.isEmpty()) {
                if (mainOutput.isEmpty()) continue;
                ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getCount());
                if (!ingredientHelper.addAsConversion(mainOutput)) continue;
                handled = true;
                continue;
            }
            if (mainOutput.isEmpty()) {
                ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getCount() * primaryMultiplier);
                if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)NSSItem.createItem((ItemStack)secondaryOutput), secondaryOutput.getCount() * secondaryMultiplier)) continue;
                handled = true;
                continue;
            }
            NSSItem nssMainOutput = NSSItem.createItem((ItemStack)mainOutput);
            NSSItem nssSecondaryOutput = NSSItem.createItem((ItemStack)secondaryOutput);
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getCount() * primaryMultiplier);
            ingredientHelper.put((NormalizedSimpleStack)nssSecondaryOutput, -secondaryOutput.getCount() * secondaryMultiplier);
            if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssMainOutput, mainOutput.getCount() * primaryMultiplier)) {
                handled = true;
            }
            ingredientHelper.resetHelper();
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getCount() * primaryMultiplier);
            ingredientHelper.put((NormalizedSimpleStack)nssMainOutput, -mainOutput.getCount() * primaryMultiplier);
            if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssSecondaryOutput, secondaryOutput.getCount() * secondaryMultiplier)) continue;
            handled = true;
        }
        return handled;
    }
}

