/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class ChemicalInfuserRecipeMapper
extends TypedMekanismRecipeMapper<ChemicalInfuserRecipe> {
    public ChemicalInfuserRecipeMapper() {
        super(ChemicalInfuserRecipe.class, MekanismRecipeType.CHEMICAL_INFUSING);
    }

    public String getName() {
        return "MekChemicalInfuser";
    }

    public String getDescription() {
        return "Maps Mekanism chemical infuser recipes.";
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, ChemicalInfuserRecipe recipe) {
        boolean handled = false;
        List<@NotNull STACK> leftInputRepresentations = recipe.getLeftInput().getRepresentations();
        List<@NotNull STACK> rightInputRepresentations = recipe.getRightInput().getRepresentations();
        for (GasStack leftRepresentation : leftInputRepresentations) {
            NSSGas nssLeft = NSSGas.createGas(leftRepresentation);
            for (GasStack rightRepresentation : rightInputRepresentations) {
                GasStack output = recipe.getOutput(leftRepresentation, rightRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssLeft, leftRepresentation.getAmount());
                ingredientHelper.put(rightRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

