/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.ISlurryProvider;
import moze_intel.projecte.api.codec.NSSCodecHolder;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class NSSSlurry
extends AbstractNSSTag<Slurry> {
    private static final boolean ALLOW_DEFAULT = false;
    public static final Codec<NSSSlurry> LEGACY_CODEC = NSSSlurry.createLegacyCodec(MekanismAPI.SLURRY_REGISTRY, (boolean)false, (String)"SLURRY|", NSSSlurry::new);
    public static final MapCodec<NSSSlurry> EXPLICIT_MAP_CODEC = NSSSlurry.createExplicitCodec(MekanismAPI.SLURRY_REGISTRY, (boolean)false, NSSSlurry::new);
    public static final Codec<NSSSlurry> EXPLICIT_CODEC = EXPLICIT_MAP_CODEC.codec();
    public static final NSSCodecHolder<NSSSlurry> CODECS = new NSSCodecHolder("SLURRY", LEGACY_CODEC, EXPLICIT_CODEC);

    private NSSSlurry(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @NotNull
    public static NSSSlurry createSlurry(@NotNull SlurryStack stack) {
        return NSSSlurry.createSlurry((Slurry)stack.getChemical());
    }

    @NotNull
    public static NSSSlurry createSlurry(@NotNull ISlurryProvider slurryProvider) {
        return NSSSlurry.createSlurry((Slurry)slurryProvider.getChemical());
    }

    @NotNull
    public static NSSSlurry createSlurry(@NotNull Slurry slurry) {
        if (slurry.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSSlurry with an empty slurry");
        }
        return NSSSlurry.createSlurry(slurry.getRegistryName());
    }

    @NotNull
    public static NSSSlurry createSlurry(@NotNull ResourceLocation slurryID) {
        return new NSSSlurry(slurryID, false);
    }

    @NotNull
    public static NSSSlurry createTag(@NotNull ResourceLocation tagId) {
        return new NSSSlurry(tagId, true);
    }

    @NotNull
    public static NSSSlurry createTag(@NotNull TagKey<Slurry> tag) {
        return NSSSlurry.createTag(tag.location());
    }

    @NotNull
    protected Registry<Slurry> getRegistry() {
        return MekanismAPI.SLURRY_REGISTRY;
    }

    protected NSSSlurry createNew(Slurry slurry) {
        return NSSSlurry.createSlurry(slurry);
    }

    public NSSCodecHolder<NSSSlurry> codecs() {
        return CODECS;
    }
}

