/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.jade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mekanism.common.integration.lookingat.ChemicalElement;
import mekanism.common.integration.lookingat.EnergyElement;
import mekanism.common.integration.lookingat.FluidElement;
import mekanism.common.integration.lookingat.ILookingAtElement;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.TextElement;
import mekanism.common.integration.lookingat.jade.JadeConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.Element;

public class JadeTooltipRenderer<ACCESSOR extends Accessor<?>>
implements IComponentProvider<ACCESSOR> {
    static final JadeTooltipRenderer<?> INSTANCE = new JadeTooltipRenderer();
    private static final MapCodec<ILookingAtElement> FLUID_OR_CHEMICAL_CODEC = JadeTooltipRenderer.alternativeElement(FluidElement.CODEC, ChemicalElement.CODEC, element -> {
        ILookingAtElement iLookingAtElement = element;
        Objects.requireNonNull(iLookingAtElement);
        ILookingAtElement selector0$temp = iLookingAtElement;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidElement.class, ChemicalElement.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                FluidElement fluidElement = (FluidElement)selector0$temp;
                yield DataResult.success((Object)Either.left((Object)fluidElement));
            }
            case 1 -> {
                ChemicalElement chemicalElement = (ChemicalElement)selector0$temp;
                yield DataResult.success((Object)Either.right((Object)chemicalElement));
            }
            default -> DataResult.error(() -> "Unknown Element Type, expected either fluid or chemical");
        };
    });
    private static final MapCodec<ILookingAtElement> ENERGY_OR_TEXT_CODEC = JadeTooltipRenderer.alternativeElement(EnergyElement.CODEC, TextElement.CODEC, element -> {
        ILookingAtElement iLookingAtElement = element;
        Objects.requireNonNull(iLookingAtElement);
        ILookingAtElement selector0$temp = iLookingAtElement;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnergyElement.class, TextElement.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                EnergyElement energyElement = (EnergyElement)selector0$temp;
                yield DataResult.success((Object)Either.left((Object)energyElement));
            }
            case 1 -> {
                TextElement textElement = (TextElement)selector0$temp;
                yield DataResult.success((Object)Either.right((Object)textElement));
            }
            default -> DataResult.error(() -> "Unknown Element Type, expected either energy or text");
        };
    });
    static final Codec<ILookingAtElement> ELEMENT_CODEC = NeoForgeExtraCodecs.withAlternative(FLUID_OR_CHEMICAL_CODEC, ENERGY_OR_TEXT_CODEC).codec();

    private static <B, L extends B, R extends B> MapCodec<B> alternativeElement(MapCodec<L> leftBase, MapCodec<R> rightBase, Function<? super B, ? extends DataResult<? extends Either<L, R>>> from) {
        MapCodec base = Codec.mapEither(leftBase, rightBase);
        return Codec.of((MapEncoder)base.flatComap(from), (MapDecoder)base.map(Either::unwrap), () -> String.valueOf(base) + "[flatComapMapped]");
    }

    public ResourceLocation getUid() {
        return JadeConstants.TOOLTIP_RENDERER;
    }

    public void appendTooltip(ITooltip tooltip, ACCESSOR accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.contains("mek_data", 9)) {
            Component lastText = null;
            RegistryOps registryOps = accessor.getLevel().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ListTag list = data.getList("mek_data", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag elementData = list.getCompound(i);
                Optional lookingAtElement = ELEMENT_CODEC.parse((DynamicOps)registryOps, (Object)elementData).result();
                if (lookingAtElement.isEmpty()) continue;
                ILookingAtElement element = (ILookingAtElement)lookingAtElement.get();
                if (element instanceof TextElement) {
                    TextElement textElement = (TextElement)element;
                    if (lastText != null) {
                        tooltip.add(lastText);
                    }
                    lastText = textElement.text();
                    continue;
                }
                ResourceLocation name = element.getID();
                if (config.get(name)) {
                    tooltip.add(new MekElement(lastText, (LookingAtElement)element).tag(name));
                }
                lastText = null;
            }
            if (lastText != null) {
                tooltip.add(lastText);
            }
        }
    }

    private static class MekElement
    extends Element {
        @Nullable
        private final Component text;
        private final LookingAtElement element;

        public MekElement(@Nullable Component text, LookingAtElement element) {
            this.element = element;
            this.text = text;
        }

        public Vec2 getSize() {
            int width = this.element.getWidth();
            int height = this.element.getHeight() + 2;
            if (this.text != null) {
                width = Math.max(width, 96);
                height += 14;
            }
            return new Vec2((float)width, (float)height);
        }

        public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
            if (this.text != null) {
                LookingAtElement.renderScaledText(Minecraft.getInstance(), guiGraphics, x + 4.0f, y + 3.0f, 0xFFFFFF, 92.0f, this.text);
                y += 13.0f;
            }
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate(x, y, 0.0f);
            this.element.render(guiGraphics, 0, 1);
            pose.popPose();
        }
    }
}

