/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import mekanism.api.math.FloatingLong;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class EnergyElement
extends LookingAtElement {
    public static final MapCodec<EnergyElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FloatingLong.CODEC.fieldOf("energy").forGetter(EnergyElement::getEnergy), (App)FloatingLong.CODEC.fieldOf("max").forGetter(EnergyElement::getMaxEnergy)).apply((Applicative)instance, EnergyElement::new));
    public static final StreamCodec<ByteBuf, EnergyElement> STREAM_CODEC = StreamCodec.composite(FloatingLong.STREAM_CODEC, EnergyElement::getEnergy, FloatingLong.STREAM_CODEC, EnergyElement::getMaxEnergy, EnergyElement::new);
    protected final FloatingLong energy;
    protected final FloatingLong maxEnergy;

    public EnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
        super(-16777216, 0xFFFFFF);
        this.energy = energy;
        this.maxEnergy = maxEnergy;
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.energy.equals(FloatingLong.MAX_VALUE)) {
            return level;
        }
        return (int)((double)level * this.energy.divideToLevel(this.maxEnergy));
    }

    public FloatingLong getEnergy() {
        return this.energy;
    }

    public FloatingLong getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return MekanismRenderer.energyIcon;
    }

    @Override
    public Component getText() {
        return EnergyDisplay.of(this.energy, this.maxEnergy).getTextComponent();
    }

    @Override
    public ResourceLocation getID() {
        return LookingAtUtils.ENERGY;
    }
}

