/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.grandpower;

import dev.technici4n.grandpower.api.ILongEnergyStorage;
import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.UnitDisplayUtils;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class GPStrictEnergyHandler
implements IStrictEnergyHandler {
    private final ILongEnergyStorage storage;

    public GPStrictEnergyHandler(ILongEnergyStorage storage) {
        this.storage = storage;
    }

    @Override
    public int getEnergyContainerCount() {
        return 1;
    }

    @Override
    public FloatingLong getEnergy(int container) {
        return container == 0 ? UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(this.storage.getAmount()) : FloatingLong.ZERO;
    }

    @Override
    public void setEnergy(int container, FloatingLong energy) {
    }

    @Override
    public FloatingLong getMaxEnergy(int container) {
        return container == 0 ? UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(this.storage.getCapacity()) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong getNeededEnergy(int container) {
        return container == 0 ? UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(Math.max(0L, this.storage.getCapacity() - this.storage.getAmount())) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong insertEnergy(int container, FloatingLong amount, @NotNull Action action) {
        return container == 0 ? this.insertEnergy(amount, action) : amount;
    }

    @Override
    public FloatingLong insertEnergy(FloatingLong amount, Action action) {
        long inserted;
        long toInsert;
        if (this.storage.canReceive() && (toInsert = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(amount)) > 0L && (inserted = this.storage.receive(toInsert, action.simulate())) > 0L) {
            return amount.subtract(UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(inserted));
        }
        return amount;
    }

    @Override
    public FloatingLong extractEnergy(int container, FloatingLong amount, @NotNull Action action) {
        return container == 0 ? this.extractEnergy(amount, action) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong extractEnergy(FloatingLong amount, Action action) {
        long toExtract;
        if (this.storage.canExtract() && (toExtract = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertToAsLong(amount)) > 0L) {
            long extracted = this.storage.extract(toExtract, action.simulate());
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(extracted);
        }
        return FloatingLong.ZERO;
    }
}

