/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.vanilla_input.RotaryRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Rotary")
public class RotaryRecipeManager
extends MekanismRecipeManager<RotaryRecipeInput, RotaryRecipe> {
    public static final RotaryRecipeManager INSTANCE = new RotaryRecipeManager();

    private RotaryRecipeManager() {
        super(MekanismRecipeType.ROTARY);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient fluidInput, ICrTChemicalStack.ICrTGasStack gasOutput) {
        this.addRecipe(name, this.makeRecipe(fluidInput, gasOutput));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, GasStackIngredient gasInput, IFluidStack fluidOutput) {
        this.addRecipe(name, this.makeRecipe(gasInput, fluidOutput));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient fluidInput, GasStackIngredient gasInput, ICrTChemicalStack.ICrTGasStack gasOutput, IFluidStack fluidOutput) {
        this.addRecipe(name, this.makeRecipe(fluidInput, gasInput, gasOutput, fluidOutput));
    }

    public final RotaryRecipe makeRecipe(CTFluidIngredient fluidInput, ICrTChemicalStack.ICrTGasStack gasOutput) {
        return new BasicRotaryRecipe(CrTUtils.fromCrT(fluidInput), this.getAndValidateNotEmpty(gasOutput));
    }

    public final RotaryRecipe makeRecipe(GasStackIngredient gasInput, IFluidStack fluidOutput) {
        return new BasicRotaryRecipe(gasInput, this.getAndValidateNotEmpty(fluidOutput));
    }

    public final RotaryRecipe makeRecipe(CTFluidIngredient fluidInput, GasStackIngredient gasInput, ICrTChemicalStack.ICrTGasStack gasOutput, IFluidStack fluidOutput) {
        return new BasicRotaryRecipe(CrTUtils.fromCrT(fluidInput), gasInput, this.getAndValidateNotEmpty(gasOutput), this.getAndValidateNotEmpty(fluidOutput));
    }

    @Override
    protected String describeOutputs(RotaryRecipe recipe) {
        StringBuilder builder = new StringBuilder();
        if (recipe.hasFluidToGas()) {
            builder.append(CrTUtils.describeOutputs(recipe.getGasOutputDefinition())).append(" for fluid to gas");
        }
        if (recipe.hasGasToFluid()) {
            if (recipe.hasFluidToGas()) {
                builder.append(" and ");
            }
            builder.append(CrTUtils.describeOutputs(recipe.getFluidOutputDefinition(), IFluidStack::of)).append(" for gas to fluid");
        }
        return builder.toString();
    }
}

