/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicPressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.vanilla_input.ReactionRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Reaction")
public class PressurizedReactionRecipeManager
extends MekanismRecipeManager<ReactionRecipeInput, PressurizedReactionRecipe> {
    public static final PressurizedReactionRecipeManager INSTANCE = new PressurizedReactionRecipeManager();

    private PressurizedReactionRecipeManager() {
        super(MekanismRecipeType.REACTION);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, IItemStack outputItem, FloatingLong energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, this.getAndValidateNotEmpty(outputItem), GasStack.EMPTY, energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, IItemStack outputItem) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, this.getAndValidateNotEmpty(outputItem), GasStack.EMPTY, FloatingLong.ZERO);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, ICrTChemicalStack.ICrTGasStack outputGas, FloatingLong energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, ItemStack.EMPTY, this.getAndValidateNotEmpty(outputGas), energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, ICrTChemicalStack.ICrTGasStack outputGas) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, ItemStack.EMPTY, this.getAndValidateNotEmpty(outputGas), FloatingLong.ZERO);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, IItemStack outputItem, ICrTChemicalStack.ICrTGasStack outputGas, FloatingLong energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, this.getAndValidateNotEmpty(outputItem), this.getAndValidateNotEmpty(outputGas), energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, IItemStack outputItem, ICrTChemicalStack.ICrTGasStack outputGas) {
        this.addRecipe(name, inputSolid, inputFluid, inputGas, duration, this.getAndValidateNotEmpty(outputItem), this.getAndValidateNotEmpty(outputGas), FloatingLong.ZERO);
    }

    private void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, ItemStack outputItem, GasStack outputGas, FloatingLong energyRequired) {
        this.addRecipe(name, this.makeRecipe(inputSolid, inputFluid, inputGas, duration, outputItem, outputGas, energyRequired));
    }

    public PressurizedReactionRecipe makeRecipe(IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, GasStackIngredient inputGas, int duration, ItemStack outputItem, GasStack outputGas, FloatingLong energyRequired) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive! Duration: " + duration);
        }
        return new BasicPressurizedReactionRecipe(CrTUtils.fromCrT(inputSolid), CrTUtils.fromCrT(inputFluid), inputGas, energyRequired.copyAsConst(), duration, outputItem, outputGas);
    }

    @Override
    protected String describeOutputs(PressurizedReactionRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), output -> {
            GasStack gasOutput;
            StringBuilder builder = new StringBuilder();
            ItemStack itemOutput = output.item();
            if (!itemOutput.isEmpty()) {
                builder.append(ItemStackUtil.getCommandString((ItemStack)itemOutput));
            }
            if (!(gasOutput = output.gas()).isEmpty()) {
                if (!itemOutput.isEmpty()) {
                    builder.append(" and ");
                }
                builder.append(new CrTChemicalStack.CrTGasStack(gasOutput));
            }
            return builder.toString();
        });
    }
}

