/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.basic.BasicFluidSlurryToSlurryRecipe;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleFluidChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.FluidSlurryToSlurry")
public abstract class FluidSlurryToSlurryRecipeManager
extends MekanismRecipeManager<SingleFluidChemicalRecipeInput<Slurry, SlurryStack>, FluidSlurryToSlurryRecipe> {
    protected FluidSlurryToSlurryRecipeManager(IMekanismRecipeTypeProvider<SingleFluidChemicalRecipeInput<Slurry, SlurryStack>, FluidSlurryToSlurryRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient fluidInput, SlurryStackIngredient slurryInput, ICrTChemicalStack.ICrTSlurryStack output) {
        this.addRecipe(name, this.makeRecipe(fluidInput, slurryInput, output));
    }

    public final FluidSlurryToSlurryRecipe makeRecipe(CTFluidIngredient fluidInput, SlurryStackIngredient slurryInput, ICrTChemicalStack.ICrTSlurryStack output) {
        return this.makeRecipe(fluidInput, slurryInput, this.getAndValidateNotEmpty(output));
    }

    protected abstract FluidSlurryToSlurryRecipe makeRecipe(CTFluidIngredient var1, SlurryStackIngredient var2, SlurryStack var3);

    @Override
    protected String describeOutputs(FluidSlurryToSlurryRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.FluidSlurryToSlurry.Washing")
    public static class ChemicalWasherRecipeManager
    extends FluidSlurryToSlurryRecipeManager {
        public static final ChemicalWasherRecipeManager INSTANCE = new ChemicalWasherRecipeManager();

        private ChemicalWasherRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleFluidChemicalRecipeInput<Slurry, SlurryStack>, FluidSlurryToSlurryRecipe, ?>)MekanismRecipeType.WASHING);
        }

        @Override
        protected FluidSlurryToSlurryRecipe makeRecipe(CTFluidIngredient fluidInput, SlurryStackIngredient slurryInput, SlurryStack output) {
            return new BasicFluidSlurryToSlurryRecipe(CrTUtils.fromCrT(fluidInput), slurryInput, output);
        }
    }
}

