/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.DecomposedRecipeBuilder;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class MekanismRecipeHandler<RECIPE extends MekanismRecipe<?>>
implements IRecipeHandler<RECIPE> {
    protected static final Object SKIP_OPTIONAL_PARAM = new Object();

    public abstract <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super RECIPE> var1, RECIPE var2, U var3);

    protected <TYPE, INGREDIENT extends InputIngredient<TYPE>> boolean ingredientConflicts(INGREDIENT a, INGREDIENT b) {
        return a.getRepresentations().stream().anyMatch(b::testType);
    }

    protected <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean chemicalIngredientConflicts(ChemicalStackIngredient<CHEMICAL, STACK, ?> a, ChemicalStackIngredient<?, ?, ?> b) {
        return ChemicalType.getTypeFor(a) == ChemicalType.getTypeFor(b) && this.ingredientConflicts(a, b);
    }

    protected String buildCommandString(IRecipeManager<? super RECIPE> manager, RecipeHolder<RECIPE> recipe, Object ... params) {
        return this.buildCommandString(manager, "addRecipe", recipe, params);
    }

    protected String buildCommandString(IRecipeManager<? super RECIPE> manager, String method, RecipeHolder<RECIPE> recipe, Object ... params) {
        StringBuilder commandString = new StringBuilder(manager.getCommandString()).append('.').append(method).append("(\"").append(recipe.id().getPath()).append('\"');
        for (Object param : params) {
            if (param == SKIP_OPTIONAL_PARAM) continue;
            commandString.append(", ").append(this.convertParam(param));
        }
        return commandString.append(");").toString();
    }

    private String convertParam(Object param) {
        if (param instanceof CommandStringDisplayable) {
            CommandStringDisplayable displayable = (CommandStringDisplayable)param;
            return displayable.getCommandString();
        }
        if (param instanceof ItemStack) {
            ItemStack stack = (ItemStack)param;
            return ItemStackUtil.getCommandString((ItemStack)stack);
        }
        if (param instanceof FluidStack) {
            FluidStack stack = (FluidStack)param;
            return IFluidStack.of((Object)stack).getCommandString();
        }
        if (param instanceof GasStack) {
            GasStack stack = (GasStack)param;
            return new CrTChemicalStack.CrTGasStack(stack).getCommandString();
        }
        if (param instanceof InfusionStack) {
            InfusionStack stack = (InfusionStack)param;
            return new CrTChemicalStack.CrTInfusionStack(stack).getCommandString();
        }
        if (param instanceof PigmentStack) {
            PigmentStack stack = (PigmentStack)param;
            return new CrTChemicalStack.CrTPigmentStack(stack).getCommandString();
        }
        if (param instanceof SlurryStack) {
            SlurryStack stack = (SlurryStack)param;
            return new CrTChemicalStack.CrTSlurryStack(stack).getCommandString();
        }
        if (param instanceof BoxedChemicalStack) {
            BoxedChemicalStack stack = (BoxedChemicalStack)param;
            return this.convertParam(stack.getChemicalStack());
        }
        if (param instanceof FloatingLong) {
            FloatingLong fl = (FloatingLong)param;
            if (fl.getDecimal() == 0) {
                return fl.toString(0);
            }
            return fl.toString().replaceAll("0*$", "");
        }
        if (param instanceof Number || param instanceof Boolean) {
            return param.toString();
        }
        if (param instanceof ItemStackIngredient) {
            ItemStackIngredient ingredient = (ItemStackIngredient)param;
            return this.convertParam(CrTUtils.toCrT(ingredient));
        }
        if (param instanceof FluidStackIngredient) {
            FluidStackIngredient ingredient = (FluidStackIngredient)param;
            return this.convertParam(CrTUtils.toCrT(ingredient));
        }
        if (param instanceof GasStackIngredient) {
            GasStackIngredient ingredient = (GasStackIngredient)param;
            return MekanismRecipeHandler.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.GasStackIngredient", CrTUtils.gasTags(), (IGasIngredient)ingredient.ingredient(), ingredient.amount());
        }
        if (param instanceof InfusionStackIngredient) {
            InfusionStackIngredient ingredient = (InfusionStackIngredient)param;
            return MekanismRecipeHandler.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.InfusionStackIngredient", CrTUtils.infuseTypeTags(), (IInfusionIngredient)ingredient.ingredient(), ingredient.amount());
        }
        if (param instanceof PigmentStackIngredient) {
            PigmentStackIngredient ingredient = (PigmentStackIngredient)param;
            return MekanismRecipeHandler.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.PigmentStackIngredient", CrTUtils.pigmentTags(), (IPigmentIngredient)ingredient.ingredient(), ingredient.amount());
        }
        if (param instanceof SlurryStackIngredient) {
            SlurryStackIngredient ingredient = (SlurryStackIngredient)param;
            return MekanismRecipeHandler.convertIngredient("mods.mekanism.api.ingredient.ChemicalStackIngredient.SlurryStackIngredient", CrTUtils.slurryTags(), (ISlurryIngredient)ingredient.ingredient(), ingredient.amount());
        }
        if (param instanceof List) {
            List list = (List)param;
            if (list.isEmpty()) {
                return "Invalid (output) list, no outputs";
            }
            return this.convertParam(list.getFirst());
        }
        if (param instanceof ElectrolysisRecipe.ElectrolysisRecipeOutput) {
            ElectrolysisRecipe.ElectrolysisRecipeOutput output = (ElectrolysisRecipe.ElectrolysisRecipeOutput)param;
            return this.convertParam(output.left()) + ", " + this.convertParam(output.right());
        }
        return "Unimplemented: " + String.valueOf(param);
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, ?, CRT_STACK>> String convertIngredient(String crtClass, KnownTagManager<CHEMICAL> tagManager, INGREDIENT ingredient, long amount) {
        if (ingredient instanceof TagChemicalIngredient) {
            TagChemicalIngredient tagIngredient = (TagChemicalIngredient)ingredient;
            KnownTag tag = (KnownTag)tagManager.tag(tagIngredient.tag());
            if (amount == 1L) {
                return tag.getCommandString();
            }
            if (amount > 0L && amount <= Integer.MAX_VALUE) {
                return tag.withAmount((int)amount).getCommandString();
            }
            return crtClass + ".from(" + tag.getCommandString() + ", " + amount + ")";
        }
        ArrayList list = new ArrayList();
        for (Chemical chemical : ingredient.getChemicals()) {
            list.add(CrTUtils.fromChemical(chemical, 1));
        }
        if (list.size() == 1) {
            return ((ICrTChemicalStack)list.getFirst()).setAmount(amount).getCommandString();
        }
        String representation = list.stream().map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(", "));
        return crtClass + ".from(" + amount + ", " + representation + ")";
    }

    protected Optional<IDecomposedRecipe> decompose(Object ... importantData) {
        TypeData<IIngredientWithAmount, CTFluidIngredient, ChemicalStackIngredient> inputs = new TypeData<IIngredientWithAmount, CTFluidIngredient, ChemicalStackIngredient>(ChemicalType::getTypeFor);
        TypeData<IItemStack, IFluidStack, ChemicalStack> outputs = new TypeData<IItemStack, IFluidStack, ChemicalStack>(ChemicalType::getTypeFor);
        int duration = -1;
        FloatingLong energy = null;
        for (Object data : importantData) {
            if (data instanceof List) {
                List dataList = (List)data;
                if (dataList.size() != 1) {
                    return Optional.empty();
                }
                data = dataList.getFirst();
            }
            if (data instanceof ItemStackIngredient) {
                ItemStackIngredient ingredient = (ItemStackIngredient)data;
                inputs.addItem(CrTUtils.toCrT(ingredient));
                continue;
            }
            if (data instanceof FluidStackIngredient) {
                FluidStackIngredient ingredient = (FluidStackIngredient)data;
                inputs.addFluid(CrTUtils.toCrT(ingredient));
                continue;
            }
            if (data instanceof ChemicalStackIngredient) {
                ChemicalStackIngredient ingredient = (ChemicalStackIngredient)data;
                inputs.addChemical(ingredient);
                continue;
            }
            if (data instanceof ItemStack) {
                ItemStack stack = (ItemStack)data;
                outputs.addItem(IItemStack.of((ItemStack)stack));
                continue;
            }
            if (data instanceof FluidStack) {
                FluidStack stack = (FluidStack)data;
                outputs.addFluid(IFluidStack.of((Object)stack));
                continue;
            }
            if (data instanceof ChemicalStack) {
                ChemicalStack stack = (ChemicalStack)data;
                outputs.addChemical(stack);
                continue;
            }
            if (data instanceof BoxedChemicalStack) {
                BoxedChemicalStack stack = (BoxedChemicalStack)data;
                outputs.addChemical(stack.getChemicalStack());
                continue;
            }
            if (data instanceof PressurizedReactionRecipe.PressurizedReactionRecipeOutput) {
                PressurizedReactionRecipe.PressurizedReactionRecipeOutput output = (PressurizedReactionRecipe.PressurizedReactionRecipeOutput)data;
                if (!output.item().isEmpty()) {
                    outputs.addItem(IItemStack.of((ItemStack)output.item()));
                }
                if (output.gas().isEmpty()) continue;
                outputs.addChemical(output.gas());
                continue;
            }
            if (data instanceof ElectrolysisRecipe.ElectrolysisRecipeOutput) {
                ElectrolysisRecipe.ElectrolysisRecipeOutput output = (ElectrolysisRecipe.ElectrolysisRecipeOutput)data;
                outputs.addChemical(output.left());
                outputs.addChemical(output.right());
                continue;
            }
            if (data instanceof Integer) {
                Integer i = (Integer)data;
                if (duration != -1) {
                    return Optional.empty();
                }
                duration = i;
                continue;
            }
            if (data instanceof FloatingLong) {
                FloatingLong fl = (FloatingLong)data;
                if (energy != null) {
                    return Optional.empty();
                }
                energy = fl;
                continue;
            }
            return Optional.empty();
        }
        DecomposedRecipeBuilder builder = IDecomposedRecipe.builder();
        inputs.addItemToBuilder(builder, CrTRecipeComponents.ITEM.input()).addFluidToBuilder(builder, CrTRecipeComponents.FLUID.input());
        outputs.addItemToBuilder(builder, CrTRecipeComponents.ITEM.output()).addFluidToBuilder(builder, CrTRecipeComponents.FLUID.output());
        for (CrTRecipeComponents.ChemicalRecipeComponent<?, ?, ?, ?> chemicalComponent : CrTRecipeComponents.CHEMICAL_COMPONENTS) {
            this.addChemicals(builder, inputs, outputs, chemicalComponent);
        }
        if (duration != -1) {
            builder.with(BuiltinRecipeComponents.Processing.TIME, (Object)duration);
        }
        if (energy != null) {
            builder.with(CrTRecipeComponents.ENERGY, energy);
        }
        return Optional.of(builder.build());
    }

    private <STACK extends ChemicalStack<?>, INGREDIENT extends ChemicalStackIngredient<?, STACK, ?>, CRT_STACK extends ICrTChemicalStack<?, STACK, CRT_STACK>> void addChemicals(DecomposedRecipeBuilder builder, TypeData<?, ?, ChemicalStackIngredient<?, ?, ?>> inputs, TypeData<?, ?, ChemicalStack<?>> outputs, CrTRecipeComponents.ChemicalRecipeComponent<?, STACK, INGREDIENT, CRT_STACK> component) {
        List outputData;
        List data = inputs.chemicalData.getOrDefault((Object)component.chemicalType(), Collections.emptyList());
        if (!data.isEmpty()) {
            builder.with(component.input(), data);
        }
        if (!(outputData = outputs.chemicalData.getOrDefault((Object)component.chemicalType(), Collections.emptyList())).isEmpty()) {
            component.withOutput(builder, outputData);
        }
    }

    private static class TypeData<ITEM, FLUID, CHEMICAL> {
        private final List<ITEM> itemData = new ArrayList<ITEM>();
        private final List<FLUID> fluidData = new ArrayList<FLUID>();
        private final Map<ChemicalType, List<CHEMICAL>> chemicalData = new EnumMap<ChemicalType, List<CHEMICAL>>(ChemicalType.class);
        private final Function<CHEMICAL, ChemicalType> typeExtractor;

        public TypeData(Function<CHEMICAL, ChemicalType> typeExtractor) {
            this.typeExtractor = typeExtractor;
        }

        private void addItem(ITEM data) {
            this.itemData.add(data);
        }

        private void addFluid(FLUID data) {
            this.fluidData.add(data);
        }

        private void addChemical(CHEMICAL data) {
            this.chemicalData.computeIfAbsent(this.typeExtractor.apply(data), type -> new ArrayList()).add(data);
        }

        private TypeData<ITEM, FLUID, CHEMICAL> addItemToBuilder(DecomposedRecipeBuilder builder, IRecipeComponent<ITEM> component) {
            if (!this.itemData.isEmpty()) {
                builder.with(component, this.itemData);
            }
            return this;
        }

        private TypeData<ITEM, FLUID, CHEMICAL> addFluidToBuilder(DecomposedRecipeBuilder builder, IRecipeComponent<FLUID> component) {
            if (!this.fluidData.isEmpty()) {
                builder.with(component, this.fluidData);
            }
            return this;
        }
    }
}

