/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Optional;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.ElectrolysisRecipeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=ElectrolysisRecipe.class)
public class ElectrolysisRecipeHandler
extends MekanismRecipeHandler<ElectrolysisRecipe> {
    public String dumpToCommandString(IRecipeManager<? super ElectrolysisRecipe> manager, RegistryAccess registryAccess, RecipeHolder<ElectrolysisRecipe> recipeHolder) {
        ElectrolysisRecipe recipe = (ElectrolysisRecipe)recipeHolder.value();
        return this.buildCommandString(manager, recipeHolder, recipe.getInput(), recipe.getOutputDefinition(), recipe.getEnergyMultiplier().equals(FloatingLong.ONE) ? SKIP_OPTIONAL_PARAM : recipe.getEnergyMultiplier());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super ElectrolysisRecipe> manager, ElectrolysisRecipe recipe, U o) {
        if (!(o instanceof ElectrolysisRecipe)) return false;
        ElectrolysisRecipe other = (ElectrolysisRecipe)o;
        if (!this.ingredientConflicts(recipe.getInput(), other.getInput())) return false;
        return true;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super ElectrolysisRecipe> manager, RegistryAccess registryAccess, ElectrolysisRecipe recipe) {
        return this.decompose(recipe.getInput(), recipe.getOutputDefinition(), recipe.getEnergyMultiplier());
    }

    public Optional<ElectrolysisRecipe> recompose(IRecipeManager<? super ElectrolysisRecipe> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof ElectrolysisRecipeManager) {
            ElectrolysisRecipeManager manager = (ElectrolysisRecipeManager)m;
            CrTUtils.UnaryTypePair<ICrTChemicalStack.ICrTGasStack> output = CrTUtils.getPair(recipe, CrTRecipeComponents.GAS.output());
            return Optional.of(manager.makeRecipe((CTFluidIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.FLUID.input()), output.a(), output.b(), CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.ENERGY).orElse(FloatingLong.ONE)));
        }
        return Optional.empty();
    }
}

