/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=SlurryStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.SlurryStackIngredient")
public class CrTSlurryStackIngredient {
    private CrTSlurryStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(Slurry instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "SlurryStackIngredients", "slurry");
        return IngredientCreatorAccess.slurryStack().from((ISlurryIngredient)((Object)instance), amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(ICrTChemicalStack.ICrTSlurryStack instance) {
        CrTIngredientHelper.assertValid(instance, "SlurryStackIngredients");
        return IngredientCreatorAccess.slurryStack().from((SlurryStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(long amount, Slurry ... slurries) {
        CrTIngredientHelper.assertMultiple(amount, "SlurryStackIngredients", "slurry", slurries);
        return IngredientCreatorAccess.slurryStack().from(amount, slurries);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(long amount, ICrTChemicalStack.ICrTSlurryStack ... slurries) {
        CrTIngredientHelper.assertMultiple(amount, "SlurryStackIngredients", "slurry", slurries);
        return IngredientCreatorAccess.slurryStack().from(amount, slurries);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(ICrTChemicalStack.ICrTSlurryStack ... slurries) {
        long amount = CrTIngredientHelper.assertMultiple("SlurryStackIngredients", "slurry", slurries);
        return IngredientCreatorAccess.slurryStack().from(amount, slurries);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(KnownTag<Slurry> slurryTag, long amount) {
        TagKey<Slurry> tag = CrTIngredientHelper.assertValidAndGet(slurryTag, amount, "SlurryStackIngredients");
        return IngredientCreatorAccess.slurryStack().from((ISlurryIngredient)tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(Many<KnownTag<Slurry>> slurryTag) {
        return CrTSlurryStackIngredient.from((KnownTag<Slurry>)((KnownTag)slurryTag.getData()), (long)slurryTag.getAmount());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(SlurryStackIngredient _this) {
        return (IData)IngredientCreatorAccess.slurryStack().codec().encodeStart((DynamicOps)IDataOps.INSTANCE.withRegistryAccess(), (Object)_this).getOrThrow();
    }

    @ZenCodeType.Method
    public static boolean testType(SlurryStackIngredient _this, ICrTChemicalStack.ICrTSlurryStack type) {
        return _this.testType((SlurryStack)type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(SlurryStackIngredient _this, ICrTChemicalStack.ICrTSlurryStack stack) {
        return _this.test((SlurryStack)stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<ICrTChemicalStack.ICrTSlurryStack> getRepresentations(SlurryStackIngredient _this) {
        return CrTUtils.convertChemical(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static SlurryStackIngredient or(SlurryStackIngredient _this, SlurryStackIngredient other) {
        if (_this.amount() != other.amount()) {
            throw new IllegalArgumentException("SlurryStack ingredients can only be or'd if they have the same counts");
        }
        ArrayList ingredients = new ArrayList();
        CrTIngredientHelper.addIngredient(ingredients, (ISlurryIngredient)_this.ingredient());
        CrTIngredientHelper.addIngredient(ingredients, (ISlurryIngredient)other.ingredient());
        return IngredientCreatorAccess.slurryStack().from(IngredientCreatorAccess.slurry().ofIngredients(ingredients), _this.amount());
    }
}

