/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=PigmentStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.PigmentStackIngredient")
public class CrTPigmentStackIngredient {
    private CrTPigmentStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(Pigment instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "PigmentStackIngredients", "pigment");
        return IngredientCreatorAccess.pigmentStack().from((IPigmentIngredient)((Object)instance), amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(ICrTChemicalStack.ICrTPigmentStack instance) {
        CrTIngredientHelper.assertValid(instance, "PigmentStackIngredients");
        return IngredientCreatorAccess.pigmentStack().from((PigmentStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(long amount, Pigment ... pigments) {
        CrTIngredientHelper.assertMultiple(amount, "PigmentStackIngredients", "pigment", pigments);
        return IngredientCreatorAccess.pigmentStack().from(amount, pigments);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(long amount, ICrTChemicalStack.ICrTPigmentStack ... pigments) {
        CrTIngredientHelper.assertMultiple(amount, "PigmentStackIngredients", "pigment", pigments);
        return IngredientCreatorAccess.pigmentStack().from(amount, pigments);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(ICrTChemicalStack.ICrTPigmentStack ... pigments) {
        long amount = CrTIngredientHelper.assertMultiple("PigmentStackIngredients", "pigment", pigments);
        return IngredientCreatorAccess.pigmentStack().from(amount, pigments);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(KnownTag<Pigment> pigmentTag, long amount) {
        TagKey<Pigment> tag = CrTIngredientHelper.assertValidAndGet(pigmentTag, amount, "PigmentStackIngredients");
        return IngredientCreatorAccess.pigmentStack().from((IPigmentIngredient)tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(Many<KnownTag<Pigment>> pigmentTag) {
        return CrTPigmentStackIngredient.from((KnownTag<Pigment>)((KnownTag)pigmentTag.getData()), (long)pigmentTag.getAmount());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(PigmentStackIngredient _this) {
        return (IData)IngredientCreatorAccess.pigmentStack().codec().encodeStart((DynamicOps)IDataOps.INSTANCE.withRegistryAccess(), (Object)_this).getOrThrow();
    }

    @ZenCodeType.Method
    public static boolean testType(PigmentStackIngredient _this, ICrTChemicalStack.ICrTPigmentStack type) {
        return _this.testType((PigmentStack)type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(PigmentStackIngredient _this, ICrTChemicalStack.ICrTPigmentStack stack) {
        return _this.test((PigmentStack)stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<ICrTChemicalStack.ICrTPigmentStack> getRepresentations(PigmentStackIngredient _this) {
        return CrTUtils.convertChemical(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static PigmentStackIngredient or(PigmentStackIngredient _this, PigmentStackIngredient other) {
        if (_this.amount() != other.amount()) {
            throw new IllegalArgumentException("InfusionStack ingredients can only be or'd if they have the same counts");
        }
        ArrayList ingredients = new ArrayList();
        CrTIngredientHelper.addIngredient(ingredients, (IPigmentIngredient)_this.ingredient());
        CrTIngredientHelper.addIngredient(ingredients, (IPigmentIngredient)other.ingredient());
        return IngredientCreatorAccess.pigmentStack().from(IngredientCreatorAccess.pigment().ofIngredients(ingredients), _this.amount());
    }
}

