/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=InfusionStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.InfusionStackIngredient")
public class CrTInfusionStackIngredient {
    private CrTInfusionStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(InfuseType instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "InfusionStackIngredients", "infuse type");
        return IngredientCreatorAccess.infusionStack().from((IInfusionIngredient)((Object)instance), amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(ICrTChemicalStack.ICrTInfusionStack instance) {
        CrTIngredientHelper.assertValid(instance, "InfusionStackIngredients");
        return IngredientCreatorAccess.infusionStack().from((InfusionStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(long amount, InfuseType ... infuseTypes) {
        CrTIngredientHelper.assertMultiple(amount, "InfusionStackIngredients", "infuse type", infuseTypes);
        return IngredientCreatorAccess.infusionStack().from(amount, infuseTypes);
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(long amount, ICrTChemicalStack.ICrTInfusionStack ... infuseTypes) {
        CrTIngredientHelper.assertMultiple(amount, "InfusionStackIngredients", "infuse type", infuseTypes);
        return IngredientCreatorAccess.infusionStack().from(amount, infuseTypes);
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(ICrTChemicalStack.ICrTInfusionStack ... infuseTypes) {
        long amount = CrTIngredientHelper.assertMultiple("InfusionStackIngredients", "infuse type", infuseTypes);
        return IngredientCreatorAccess.infusionStack().from(amount, infuseTypes);
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(KnownTag<InfuseType> infuseTypeTag, long amount) {
        TagKey<InfuseType> tag = CrTIngredientHelper.assertValidAndGet(infuseTypeTag, amount, "InfusionStackIngredients");
        return IngredientCreatorAccess.infusionStack().from((IInfusionIngredient)tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static InfusionStackIngredient from(Many<KnownTag<InfuseType>> infuseTypeTag) {
        return CrTInfusionStackIngredient.from((KnownTag<InfuseType>)((KnownTag)infuseTypeTag.getData()), (long)infuseTypeTag.getAmount());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(InfusionStackIngredient _this) {
        return (IData)IngredientCreatorAccess.infusionStack().codec().encodeStart((DynamicOps)IDataOps.INSTANCE.withRegistryAccess(), (Object)_this).getOrThrow();
    }

    @ZenCodeType.Method
    public static boolean testType(InfusionStackIngredient _this, ICrTChemicalStack.ICrTInfusionStack type) {
        return _this.testType((InfusionStack)type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(InfusionStackIngredient _this, ICrTChemicalStack.ICrTInfusionStack stack) {
        return _this.test((InfusionStack)stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<ICrTChemicalStack.ICrTInfusionStack> getRepresentations(InfusionStackIngredient _this) {
        return CrTUtils.convertChemical(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static InfusionStackIngredient or(InfusionStackIngredient _this, InfusionStackIngredient other) {
        if (_this.amount() != other.amount()) {
            throw new IllegalArgumentException("InfusionStack ingredients can only be or'd if they have the same counts");
        }
        ArrayList ingredients = new ArrayList();
        CrTIngredientHelper.addIngredient(ingredients, (IInfusionIngredient)_this.ingredient());
        CrTIngredientHelper.addIngredient(ingredients, (IInfusionIngredient)other.ingredient());
        return IngredientCreatorAccess.infusionStack().from(IngredientCreatorAccess.infusion().ofIngredients(ingredients), _this.amount());
    }
}

