/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import mekanism.common.integration.crafttweaker.bracket.IBracketSupport;
import mekanism.common.integration.crafttweaker.ingredient.CrTGasStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTInfusionStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTPigmentStackIngredient;
import mekanism.common.integration.crafttweaker.ingredient.CrTSlurryStackIngredient;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.chemical.ChemicalStack")
public interface ICrTChemicalStack<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>>
extends CommandStringDisplayable,
IBracketSupport,
IChemicalProvider<CHEMICAL> {
    @Override
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    @NotNull
    default public ResourceLocation getRegistryName() {
        return ((ChemicalStack)this.getInternal()).getTypeRegistryName();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return ((ChemicalStack)this.getInternal()).isEmpty();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="amount")
    default public long getAmount() {
        return ((ChemicalStack)this.getInternal()).getAmount();
    }

    @ZenCodeType.Method
    public CRT_STACK setAmount(long var1);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public CRT_STACK multiply(long amount) {
        return this.setAmount(this.getAmount() * amount);
    }

    @ZenCodeType.Method
    default public CRT_STACK grow(long amount) {
        return this.setAmount(this.getAmount() + amount);
    }

    @ZenCodeType.Method
    default public CRT_STACK shrink(long amount) {
        return this.setAmount(this.getAmount() - amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean containsOther(CRT_STACK stack) {
        return this.getAmount() >= stack.getAmount() && this.isTypeEqual(stack);
    }

    @ZenCodeType.Method
    public CRT_STACK asMutable();

    @ZenCodeType.Method
    public CRT_STACK asImmutable();

    @ZenCodeType.Method
    public CRT_STACK copy();

    @Override
    @ZenCodeType.Method(value="getType")
    @ZenCodeType.Getter(value="type")
    @ZenCodeType.Caster(implicit=true)
    @NotNull
    default public CHEMICAL getChemical() {
        return ((ChemicalStack)this.getInternal()).getChemical();
    }

    public STACK getInternal();

    default public STACK getImmutableInternal() {
        return this.copy().getInternal();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean isTypeEqual(CRT_STACK stack) {
        return ChemicalStack.isSameChemical(this.getInternal(), stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    default public boolean isEqual(CRT_STACK other) {
        return this.equals(other);
    }

    @ZenCodeType.Caster(implicit=true)
    public ChemicalStackIngredient<?, ?, ?> asChemicalStackIngredient();

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.SlurryStack")
    public static interface ICrTSlurryStack
    extends ICrTChemicalStack<Slurry, SlurryStack, ICrTSlurryStack>,
    IBracketSupport.ISlurryBracketSupport,
    ISlurryProvider {
        @Override
        default public ChemicalStackIngredient<Slurry, SlurryStack, ISlurryIngredient> asChemicalStackIngredient() {
            return this.asSlurryStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public SlurryStackIngredient asSlurryStackIngredient() {
            return CrTSlurryStackIngredient.from(this);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.PigmentStack")
    public static interface ICrTPigmentStack
    extends ICrTChemicalStack<Pigment, PigmentStack, ICrTPigmentStack>,
    IBracketSupport.IPigmentBracketSupport,
    IPigmentProvider {
        @Override
        default public ChemicalStackIngredient<Pigment, PigmentStack, IPigmentIngredient> asChemicalStackIngredient() {
            return this.asPigmentStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public PigmentStackIngredient asPigmentStackIngredient() {
            return CrTPigmentStackIngredient.from(this);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.InfusionStack")
    public static interface ICrTInfusionStack
    extends ICrTChemicalStack<InfuseType, InfusionStack, ICrTInfusionStack>,
    IBracketSupport.IInfuseTypeBracketSupport,
    IInfuseTypeProvider {
        @Override
        default public ChemicalStackIngredient<InfuseType, InfusionStack, IInfusionIngredient> asChemicalStackIngredient() {
            return this.asInfusionStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public InfusionStackIngredient asInfusionStackIngredient() {
            return CrTInfusionStackIngredient.from(this);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.api.chemical.GasStack")
    public static interface ICrTGasStack
    extends ICrTChemicalStack<Gas, GasStack, ICrTGasStack>,
    IBracketSupport.IGasBracketSupport,
    IGasProvider {
        @Override
        default public ChemicalStackIngredient<Gas, GasStack, IGasIngredient> asChemicalStackIngredient() {
            return this.asGasStackIngredient();
        }

        @ZenCodeType.Caster(implicit=true)
        default public GasStackIngredient asGasStackIngredient() {
            return CrTGasStackIngredient.from(this);
        }
    }
}

