/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.robit.IRobit;
import mekanism.api.robit.RobitSkin;
import mekanism.api.security.IEntitySecurityUtils;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.ILangEntry;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.ChangeRobitSkinTrigger;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.base.holiday.HolidayManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.ai.RobitAIFollow;
import mekanism.common.entity.ai.RobitAIPickup;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemRobit;
import mekanism.common.lib.security.EntitySecurityUtils;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.RecipeCacheLookupMonitor;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.registries.MekanismDataSerializers;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRobit
extends PathfinderMob
implements IRobit,
IMekanismInventory,
IMekanismStrictEnergyHandler,
ISingleRecipeLookupHandler.ItemRecipeLookupHandler<ItemStackToItemStackRecipe> {
    public static final ModelProperty<ResourceLocation> SKIN_TEXTURE_PROPERTY = new ModelProperty();
    private static final TicketType<Integer> ROBIT_CHUNK_UNLOAD = TicketType.create((String)"robit_chunk_unload", Integer::compareTo, (int)20);
    private static final EntityDataAccessor<UUID> OWNER_UUID = EntityRobit.define((EntityDataSerializer)MekanismDataSerializers.UUID.value());
    private static final EntityDataAccessor<String> OWNER_NAME = EntityRobit.define(EntityDataSerializers.STRING);
    private static final EntityDataAccessor<SecurityMode> SECURITY = EntityRobit.define((EntityDataSerializer)MekanismDataSerializers.SECURITY.value());
    private static final EntityDataAccessor<Boolean> FOLLOW = EntityRobit.define(EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DROP_PICKUP = EntityRobit.define(EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DEFAULT_SKIN_MANUALLY_SELECTED = EntityRobit.define(EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ResourceKey<RobitSkin>> SKIN = EntityRobit.define((EntityDataSerializer)MekanismDataSerializers.ROBIT_SKIN.value());
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final FloatingLong MAX_ENERGY = FloatingLong.createConst(100000L);
    private static final FloatingLong DISTANCE_MULTIPLIER = FloatingLong.createConst(1.5);
    private static final int ticksRequired = 100;
    @Nullable
    private GlobalPos homeLocation;
    private int lastTextureUpdate;
    private int textureIndex;
    private int progress;
    private final Set<Player> playersUsing = new ObjectOpenHashSet();
    private final RecipeCacheLookupMonitor<ItemStackToItemStackRecipe> recipeCacheLookupMonitor;
    private final BooleanSupplier recheckAllRecipeErrors;
    private final boolean[] trackedErrors = new boolean[TRACKED_ERROR_TYPES.size()];
    private final IInputHandler<@NotNull ItemStack> inputHandler;
    private final IOutputHandler<@NotNull ItemStack> outputHandler;
    @NotNull
    private final List<IInventorySlot> inventorySlots;
    @NotNull
    private final List<IInventorySlot> mainContainerSlots;
    @NotNull
    private final List<IInventorySlot> smeltingContainerSlots;
    @NotNull
    private final List<IInventorySlot> inventoryContainerSlots;
    private final EnergyInventorySlot energySlot;
    private final InputInventorySlot smeltingInputSlot;
    private final OutputInventorySlot smeltingOutputSlot;
    private final List<IEnergyContainer> energyContainers;
    private final BasicEnergyContainer energyContainer;

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    private static <T> EntityDataAccessor<T> define(EntityDataSerializer<T> dataSerializer) {
        return SynchedEntityData.defineId(EntityRobit.class, dataSerializer);
    }

    public EntityRobit(EntityType<EntityRobit> type, Level world) {
        super(type, world);
        this.getNavigation().setCanFloat(false);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setCustomNameVisible(true);
        this.recipeCacheLookupMonitor = new RecipeCacheLookupMonitor<ItemStackToItemStackRecipe>(this);
        int checkOffset = this.level().random.nextInt(100);
        this.recheckAllRecipeErrors = () -> !this.playersUsing.isEmpty() && this.level().getGameTime() % 100L == (long)checkOffset;
        IContentsListener recipeCacheUnpauseListener = () -> {
            this.onContentsChanged();
            this.recipeCacheLookupMonitor.unpause();
        };
        this.energyContainer = BasicEnergyContainer.input(MAX_ENERGY, recipeCacheUnpauseListener);
        this.energyContainers = Collections.singletonList(this.energyContainer);
        this.inventorySlots = new ArrayList<IInventorySlot>();
        this.inventoryContainerSlots = new ArrayList<IInventorySlot>();
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot2 = BasicInventorySlot.at(this, 8 + slotX * 18, 18 + slotY * 18);
                this.inventorySlots.add(slot2);
                this.inventoryContainerSlots.add(slot2);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((EntityRobit)this).level(), this, 153, 17);
        this.inventorySlots.add(this.energySlot);
        this.smeltingInputSlot = InputInventorySlot.at(this::containsRecipe, this.recipeCacheLookupMonitor, 51, 35);
        this.inventorySlots.add(this.smeltingInputSlot);
        this.smeltingOutputSlot = OutputInventorySlot.at(recipeCacheUnpauseListener, 116, 35);
        this.inventorySlots.add(this.smeltingOutputSlot);
        this.smeltingInputSlot.tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.smeltingOutputSlot.tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE)));
        this.mainContainerSlots = Collections.singletonList(this.energySlot);
        this.smeltingContainerSlots = List.of(this.smeltingInputSlot, this.smeltingOutputSlot);
        this.inputHandler = InputHelper.getInputHandler(this.smeltingInputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler(this.smeltingOutputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @Nullable
    public static EntityRobit create(Level world, double x, double y, double z) {
        EntityRobit robit = (EntityRobit)((EntityType)MekanismEntityTypes.ROBIT.get()).create(world);
        if (robit == null) {
            return null;
        }
        robit.setPos(x, y, z);
        robit.xo = x;
        robit.yo = y;
        robit.zo = z;
        return robit;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RobitAIPickup(this, 1.0f));
        this.goalSelector.addGoal(2, (Goal)new RobitAIFollow(this, 1.0f, 4.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.level();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_UUID, (Object)Mekanism.gameProfile.getId());
        builder.define(OWNER_NAME, (Object)"");
        builder.define(SECURITY, (Object)SecurityMode.PUBLIC);
        builder.define(FOLLOW, (Object)false);
        builder.define(DROP_PICKUP, (Object)false);
        builder.define(DEFAULT_SKIN_MANUALLY_SELECTED, (Object)false);
        builder.define(SKIN, MekanismRobitSkins.BASE);
    }

    private FloatingLong getRoundedTravelEnergy() {
        return DISTANCE_MULTIPLIER.multiply(Math.sqrt(this.distanceToSqr(this.xo, this.yo, this.zo)));
    }

    public void onRemovedFromWorld() {
        if (this.level() != null && !this.level().isClientSide && this.getFollowing() && this.getOwner() != null) {
            ((ServerLevel)this.level()).getChunkSource().addRegionTicket(ROBIT_CHUNK_UNLOAD, new ChunkPos(this.blockPosition()), 2, (Object)this.getId());
        }
        super.onRemovedFromWorld();
    }

    public void tick() {
        Level level = this.level();
        if (!level.isClientSide) {
            BlockPos homePos;
            MinecraftServer server;
            Object serverWorld;
            if (this.homeLocation == null) {
                this.discard();
                return;
            }
            if (this.tickCount % 20 == 0 && WorldUtils.isBlockLoaded((BlockGetter)(serverWorld = level.dimension() == this.homeLocation.dimension() ? level : ((server = this.getServer()) == null ? null : server.getLevel(this.homeLocation.dimension()))), homePos = this.homeLocation.pos()) && WorldUtils.getTileEntity(TileEntityChargepad.class, (BlockGetter)serverWorld, homePos) == null) {
                this.drop();
                this.discard();
                return;
            }
        }
        super.tick();
    }

    public void baseTick() {
        Player owner;
        if (!this.level().isClientSide && this.getFollowing() && (owner = this.getOwner()) != null && this.distanceToSqr((Entity)owner) > 4.0 && !this.getNavigation().isDone() && !this.energyContainer.isEmpty()) {
            this.energyContainer.extract(this.getRoundedTravelEnergy(), Action.EXECUTE, AutomationType.INTERNAL);
        }
        super.baseTick();
        if (!this.level().isClientSide) {
            if (this.getDropPickup()) {
                this.collectItems();
            }
            if (this.energyContainer.isEmpty() && !this.isOnChargepad()) {
                this.goHome();
            }
            this.energySlot.fillContainerOrConvert();
            this.recipeCacheLookupMonitor.updateAndProcess();
            if (!this.isDefaultSkinManuallySelected() && HolidayManager.hasRobitSkinsToday() && this.getSkin() == MekanismRobitSkins.BASE) {
                this.setSkin(HolidayManager.getRandomBaseSkin(this.level().random), null);
            }
        }
    }

    public boolean isItemValid(ItemEntity item) {
        return item.isAlive() && !item.hasPickUpDelay() && !(item.getItem().getItem() instanceof ItemRobit);
    }

    private void collectItems() {
        List items = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.5, 1.5, 1.5));
        if (!items.isEmpty()) {
            block0: for (ItemEntity item : items) {
                if (!this.isItemValid(item)) continue;
                for (IInventorySlot slot : this.inventoryContainerSlots) {
                    if (slot.isEmpty()) {
                        slot.setStack(item.getItem());
                        this.take((Entity)item, item.getItem().getCount());
                        item.discard();
                        this.playSound(SoundEvents.ITEM_PICKUP, 1.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        continue block0;
                    }
                    ItemStack itemStack = slot.getStack();
                    int maxSize = slot.getLimit(itemStack);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)item.getItem()) || itemStack.getCount() >= maxSize) continue;
                    int needed = maxSize - itemStack.getCount();
                    int toAdd = Math.min(needed, item.getItem().getCount());
                    MekanismUtils.logMismatchedStackSize(slot.growStack(toAdd, Action.EXECUTE), toAdd);
                    item.getItem().shrink(toAdd);
                    this.take((Entity)item, toAdd);
                    if (item.getItem().isEmpty()) {
                        item.discard();
                    }
                    this.playSound(SoundEvents.ITEM_PICKUP, 1.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue block0;
                }
            }
        }
    }

    public void goHome() {
        if (this.level().isClientSide() || this.homeLocation == null) {
            return;
        }
        MekanismTeleportEvent.Robit event = new MekanismTeleportEvent.Robit(this);
        if (((MekanismTeleportEvent.Robit)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        this.setFollowing(false);
        if (!event.isTransDimensional()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.teleportTo(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        } else {
            ServerLevel newWorld = ((ServerLevel)this.level()).getServer().getLevel(event.getTargetDimension());
            if (newWorld != null) {
                Vec3 destination = event.getTarget();
                this.changeDimension(new DimensionTransition(newWorld, destination, Vec3.ZERO, this.getYRot(), this.getXRot(), DimensionTransition.DO_NOTHING));
            }
        }
    }

    private boolean isOnChargepad() {
        return WorldUtils.getTileEntity(TileEntityChargepad.class, (BlockGetter)this.level(), this.blockPosition()) != null;
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        MenuProvider provider;
        if (!IEntitySecurityUtils.INSTANCE.canAccessOrDisplayError(player, this)) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.isEmpty() && stack.getItem() instanceof ItemConfigurator) {
                if (!this.level().isClientSide) {
                    this.drop();
                }
                this.discard();
                player.swing(hand);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide && (provider = MekanismContainerTypes.MAIN_ROBIT.getProvider((ILangEntry)MekanismLang.ROBIT, (Object)this, true)) != null) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)player);
            player.openMenu(provider, buf -> buf.writeVarInt(this.getId()));
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    private ItemStack getItemVariant() {
        ISecurityObject security;
        ItemStack stack = MekanismItems.ROBIT.getItemStack();
        IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapability(stack);
        if (energyHandlerItem != null && energyHandlerItem.getEnergyContainerCount() > 0) {
            energyHandlerItem.setEnergy(0, this.energyContainer.getEnergy());
        }
        ContainerType.ITEM.copyToStack((HolderLookup.Provider)this.level().registryAccess(), this.getInventorySlots(null), stack);
        if (this.hasCustomName()) {
            stack.set(MekanismDataComponents.ROBIT_NAME, (Object)this.getName());
        }
        if ((security = IItemSecurityUtils.INSTANCE.securityCapability(stack)) != null) {
            security.setOwnerUUID(this.getOwnerUUID());
            security.setSecurityMode(this.getSecurityMode());
        }
        stack.set(MekanismDataComponents.DEFAULT_MANUALLY_SELECTED, (Object)this.isDefaultSkinManuallySelected());
        stack.set(MekanismDataComponents.ROBIT_SKIN, this.getSkin());
        return stack;
    }

    public void drop() {
        ItemEntity entityItem = new ItemEntity(this.level(), this.getX(), this.getY() + 0.3, this.getZ(), this.getItemVariant());
        entityItem.setDeltaMovement(0.0, this.random.nextGaussian() * (double)0.05f + (double)0.2f, 0.0);
        this.level().addFreshEntity((Entity)entityItem);
    }

    public double getScaledProgress() {
        return (double)this.getOperatingTicks() / 100.0;
    }

    public int getOperatingTicks() {
        return this.progress;
    }

    @Override
    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getOperatingTicks();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbtTags) {
        Optional result;
        super.addAdditionalSaveData(nbtTags);
        RegistryAccess provider = this.registryAccess();
        nbtTags.putUUID("owner", this.getOwnerUUID());
        NBTUtils.writeEnum(nbtTags, "security_mode", this.getSecurityMode());
        nbtTags.putBoolean("follow", this.getFollowing());
        nbtTags.putBoolean("pickup_drops", this.getDropPickup());
        if (this.homeLocation != null && (result = GlobalPos.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.homeLocation).result()).isPresent()) {
            nbtTags.put("home_location", (Tag)result.get());
        }
        ContainerType.ITEM.saveTo((HolderLookup.Provider)provider, nbtTags, this.getInventorySlots(null));
        ContainerType.ENERGY.saveTo((HolderLookup.Provider)provider, nbtTags, this.getEnergyContainers(null));
        nbtTags.putInt("progress", this.getOperatingTicks());
        NBTUtils.writeResourceKey(nbtTags, "skin", this.getSkin());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbtTags) {
        super.readAdditionalSaveData(nbtTags);
        RegistryAccess provider = this.registryAccess();
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", this::setOwnerUUID);
        NBTUtils.setEnumIfPresent(nbtTags, "security_mode", SecurityMode.BY_ID, this::setSecurityMode);
        this.setFollowing(nbtTags.getBoolean("follow"));
        this.setDropPickup(nbtTags.getBoolean("pickup_drops"));
        NBTUtils.setCompoundIfPresent(nbtTags, "home_location", arg_0 -> this.lambda$readAdditionalSaveData$5((HolderLookup.Provider)provider, arg_0));
        ContainerType.ITEM.readFrom((HolderLookup.Provider)provider, nbtTags, this.getInventorySlots(null));
        ContainerType.ENERGY.readFrom((HolderLookup.Provider)provider, nbtTags, this.getEnergyContainers(null));
        this.progress = nbtTags.getInt("progress");
        NBTUtils.setResourceKeyIfPresentElse(nbtTags, "skin", MekanismAPI.ROBIT_SKIN_REGISTRY_NAME, skin -> this.setSkin((ResourceKey<RobitSkin>)skin, null), () -> this.setSkin(MekanismRobitSkins.BASE, null));
    }

    public void onDamageTaken(@NotNull DamageContainer damageContainer) {
        this.energyContainer.extract(FloatingLong.create(1000.0f * damageContainer.getNewDamage()), Action.EXECUTE, AutomationType.INTERNAL);
        this.setHealth(this.getMaxHealth());
    }

    protected void tickDeath() {
    }

    public void setHome(GlobalPos home) {
        this.homeLocation = home;
    }

    @Override
    @Nullable
    public GlobalPos getHome() {
        return this.homeLocation;
    }

    public boolean isPushable() {
        return !this.energyContainer.isEmpty();
    }

    public Player getOwner() {
        return this.level().getPlayerByUUID(this.getOwnerUUID());
    }

    @Override
    @NotNull
    public String getOwnerName() {
        return (String)this.entityData.get(OWNER_NAME);
    }

    @Override
    @NotNull
    public UUID getOwnerUUID() {
        return (UUID)this.entityData.get(OWNER_UUID);
    }

    @Override
    @NotNull
    public SecurityMode getSecurityMode() {
        return (SecurityMode)this.entityData.get(SECURITY);
    }

    @Override
    public void setSecurityMode(@NotNull SecurityMode mode) {
        SecurityMode current = this.getSecurityMode();
        if (current != mode) {
            this.entityData.set(SECURITY, (Object)mode);
            this.onSecurityChanged(current, mode);
        }
    }

    @Override
    public void onSecurityChanged(@NotNull SecurityMode old, @NotNull SecurityMode mode) {
        if (!this.level().isClientSide) {
            EntitySecurityUtils.get().securityChanged(this.playersUsing, (Entity)this, old, mode);
        }
    }

    public void open(Player player) {
        this.playersUsing.add(player);
    }

    public void close(Player player) {
        this.playersUsing.remove(player);
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
        this.entityData.set(OWNER_UUID, (Object)uuid);
        this.entityData.set(OWNER_NAME, (Object)MekanismUtils.getLastKnownUsername(uuid));
    }

    public boolean getFollowing() {
        return (Boolean)this.entityData.get(FOLLOW);
    }

    public void setFollowing(boolean follow) {
        this.entityData.set(FOLLOW, (Object)follow);
    }

    public boolean getDropPickup() {
        return (Boolean)this.entityData.get(DROP_PICKUP);
    }

    public void setDropPickup(boolean pickup) {
        this.entityData.set(DROP_PICKUP, (Object)pickup);
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.hasInventory() ? this.inventorySlots : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.canHandleEnergy() ? this.energyContainers : Collections.emptyList();
    }

    @Override
    public void onContentsChanged() {
    }

    @NotNull
    public List<IInventorySlot> getContainerInventorySlots(@NotNull MenuType<?> containerType) {
        if (!this.hasInventory()) {
            return Collections.emptyList();
        }
        if (containerType == MekanismContainerTypes.INVENTORY_ROBIT.get()) {
            return this.inventoryContainerSlots;
        }
        if (containerType == MekanismContainerTypes.MAIN_ROBIT.get()) {
            return this.mainContainerSlots;
        }
        if (containerType == MekanismContainerTypes.SMELTING_ROBIT.get()) {
            return this.smeltingContainerSlots;
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public IMekanismRecipeTypeProvider<SingleRecipeInput, ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> getRecipeType() {
        return MekanismRecipeType.SMELTING;
    }

    @Override
    public IRecipeViewerRecipeType<ItemStackToItemStackRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.SMELTING;
    }

    @Override
    @Nullable
    public ItemStackToItemStackRecipe getRecipe(int cacheIndex) {
        return (ItemStackToItemStackRecipe)this.findFirstRecipe(this.inputHandler);
    }

    public IEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public ItemStack getPickedResult(@NotNull HitResult target) {
        return this.getItemVariant();
    }

    @Override
    public void clearRecipeErrors(int cacheIndex) {
        Arrays.fill(this.trackedErrors, false);
    }

    @Override
    @NotNull
    public CachedRecipe<ItemStackToItemStackRecipe> createNewCachedRecipe(@NotNull ItemStackToItemStackRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.itemToItem(recipe, this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(errors -> {
            for (int i = 0; i < this.trackedErrors.length; ++i) {
                this.trackedErrors[i] = errors.contains(TRACKED_ERROR_TYPES.get(i));
            }
        }).setEnergyRequirements(MekanismConfig.usage.energizedSmelter, this.energyContainer).setRequiredTicks(() -> 100).setOnFinish(this::onContentsChanged).setOperatingTicksChanged(operatingTicks -> {
            this.progress = operatingTicks;
        });
    }

    public BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error) {
        int errorIndex = TRACKED_ERROR_TYPES.indexOf(error);
        if (errorIndex == -1) {
            return () -> false;
        }
        return () -> this.trackedErrors[errorIndex];
    }

    public void addContainerTrackers(MekanismContainer container) {
        MenuType containerType = container.getType();
        if (containerType == MekanismContainerTypes.MAIN_ROBIT.get()) {
            container.track(SyncableFloatingLong.create(this.energyContainer::getEnergy, this.energyContainer::setEnergy));
        } else if (containerType == MekanismContainerTypes.SMELTING_ROBIT.get()) {
            container.track(SyncableInt.create(() -> this.progress, value -> {
                this.progress = value;
            }));
            container.trackArray(this.trackedErrors);
        }
    }

    public ContainerLevelAccess getWorldPosCallable() {
        if (this.level().isClientSide) {
            return ContainerLevelAccess.NULL;
        }
        return new ContainerLevelAccess(){

            @NotNull
            public <T> Optional<T> evaluate(@NotNull BiFunction<Level, BlockPos, T> worldBlockPosTBiFunction) {
                return Optional.ofNullable(worldBlockPosTBiFunction.apply(EntityRobit.this.level(), EntityRobit.this.blockPosition()));
            }
        };
    }

    public boolean isDefaultSkinManuallySelected() {
        return (Boolean)this.entityData.get(DEFAULT_SKIN_MANUALLY_SELECTED);
    }

    public void setDefaultSkinManuallySelected(boolean value) {
        this.entityData.set(DEFAULT_SKIN_MANUALLY_SELECTED, (Object)value);
    }

    @Override
    @NotNull
    public ResourceKey<RobitSkin> getSkin() {
        return (ResourceKey)this.entityData.get(SKIN);
    }

    @Override
    public boolean setSkin(@NotNull ResourceKey<RobitSkin> skinKey, @Nullable Player player) {
        Objects.requireNonNull(skinKey, "Robit skin cannot be null.");
        if (this.getSkin() == skinKey) {
            return true;
        }
        if (player != null) {
            if (!IEntitySecurityUtils.INSTANCE.canAccess(player, this)) {
                return false;
            }
            MekanismRobitSkins.SkinLookup skinLookup = MekanismRobitSkins.lookup(this.level().registryAccess(), skinKey);
            skinKey = skinLookup.name();
            if (this.getSkin() == skinKey) {
                return true;
            }
            if (!skinLookup.skin().isUnlocked(player)) {
                return false;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((ChangeRobitSkinTrigger)((Object)MekanismCriteriaTriggers.CHANGE_ROBIT_SKIN.value())).trigger(serverPlayer, skinKey);
            }
        }
        this.entityData.set(SKIN, skinKey);
        if (skinKey == MekanismRobitSkins.BASE) {
            this.setDefaultSkinManuallySelected(true);
        }
        return true;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(SKIN_TEXTURE_PROPERTY, (Object)this.getModelTexture()).build();
    }

    private ResourceLocation getModelTexture() {
        List<ResourceLocation> textures;
        ResourceKey<RobitSkin> skinKey;
        Registry robitSkins = this.level().registryAccess().registryOrThrow(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
        RobitSkin skin = (RobitSkin)robitSkins.get(skinKey = this.getSkin());
        if (skin == null) {
            Mekanism.logger.error("Unknown Robit Skin: {}; resetting skin to base.", (Object)skinKey.location());
            skinKey = MekanismRobitSkins.BASE;
            this.setSkin(skinKey, null);
            skin = (RobitSkin)robitSkins.getOrThrow(skinKey);
        }
        if ((textures = skin.textures()).isEmpty()) {
            this.textureIndex = 0;
            if (skinKey != MekanismRobitSkins.BASE) {
                Mekanism.logger.error("Robit Skin: {}, has no textures; resetting skin to base.", (Object)skinKey.location());
                skinKey = MekanismRobitSkins.BASE;
                this.setSkin(skinKey, null);
                skin = (RobitSkin)robitSkins.getOrThrow(skinKey);
            }
            if (skin.textures().isEmpty()) {
                throw new IllegalStateException("Base robit skin has no textures defined.");
            }
            return this.getModelTexture();
        }
        int textureCount = textures.size();
        if (textureCount == 1) {
            this.textureIndex = 0;
        } else {
            if (this.lastTextureUpdate < this.tickCount) {
                this.lastTextureUpdate = this.tickCount;
                if (Math.abs(this.getX() - this.xo) + Math.abs(this.getZ() - this.zo) > 0.001 && this.tickCount % 3 == 0) {
                    ++this.textureIndex;
                }
            }
            if (this.textureIndex >= textureCount) {
                this.textureIndex %= textureCount;
            }
        }
        return textures.get(this.textureIndex);
    }

    private /* synthetic */ void lambda$readAdditionalSaveData$5(HolderLookup.Provider provider, CompoundTag home) {
        this.homeLocation = GlobalPos.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)home).result().orElse(null);
    }
}

