/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class SorterModIDFilter
extends SorterFilter<SorterModIDFilter>
implements IModIDFilter<SorterModIDFilter> {
    public static final MapCodec<SorterModIDFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> SorterModIDFilter.baseSorterCodec(instance).and((App)Codec.STRING.fieldOf("modid").forGetter(SorterModIDFilter::getModID)).apply((Applicative)instance, SorterModIDFilter::new));
    public static final StreamCodec<ByteBuf, SorterModIDFilter> STREAM_CODEC = StreamCodec.composite(SorterModIDFilter.baseSorterStreamCodec(SorterModIDFilter::new), Function.identity(), (StreamCodec)ByteBufCodecs.STRING_UTF8, SorterModIDFilter::getModID, (filter, modID) -> {
        filter.modID = modID;
        return filter;
    });
    private String modID;

    public SorterModIDFilter() {
    }

    protected SorterModIDFilter(boolean enabled, boolean allowDefault, boolean sizeMode, int min, int max, Optional<EnumColor> color, String modID) {
        super(enabled, allowDefault, sizeMode, min, max, color.orElse(null));
        this.modID = modID;
    }

    public SorterModIDFilter(SorterModIDFilter filter) {
        super(filter);
        this.modID = filter.modID;
    }

    @Override
    public Finder getFinder() {
        return Finder.modID(this.modID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modID);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterModIDFilter other = (SorterModIDFilter)o;
        return this.modID.equals(other.modID);
    }

    @Override
    public SorterModIDFilter clone() {
        return new SorterModIDFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_MODID_FILTER;
    }

    @Override
    public void setModID(String id) {
        this.modID = id;
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

