/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.sps;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.tile.multiblock.TileEntitySPSPort;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SPSMultiblockData
extends MultiblockData
implements IValveHandler {
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public IGasTank inputTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    public IGasTank outputTank;
    public final SyncableCoilData coilData = new SyncableCoilData();
    private final List<MultiblockData.CapabilityOutputTarget<IGasHandler>> gasOutputTargets = new ArrayList<MultiblockData.CapabilityOutputTarget<IGasHandler>>();
    @ContainerSync
    public double progress;
    @ContainerSync
    public int inputProcessed = 0;
    public FloatingLong receivedEnergy = FloatingLong.ZERO;
    @ContainerSync
    public FloatingLong lastReceivedEnergy = FloatingLong.ZERO;
    @ContainerSync
    public double lastProcessed;
    public boolean couldOperate;
    private AABB deathZone;

    public SPSMultiblockData(TileEntitySPSCasing tile) {
        super(tile);
        this.inputTank = MultiblockChemicalTankBuilder.GAS.input(this, this::getMaxInputGas, gas -> gas == MekanismGases.POLONIUM.get(), ChemicalAttributeValidator.ALWAYS_ALLOW, this.createSaveAndComparator());
        this.gasTanks.add(this.inputTank);
        this.outputTank = MultiblockChemicalTankBuilder.GAS.output(this, MekanismConfig.general.spsOutputTankCapacity, gas -> gas == MekanismGases.ANTIMATTER.get(), ChemicalAttributeValidator.ALWAYS_ALLOW, this);
        this.gasTanks.add(this.outputTank);
    }

    @Override
    public void onCreated(Level world) {
        super.onCreated(world);
        this.deathZone = AABB.encapsulatingFullBlocks((BlockPos)this.getMinPos().offset(1, 1, 1), (BlockPos)this.getMaxPos().offset(-1, -1, -1));
    }

    private long getMaxInputGas() {
        return (long)MekanismConfig.general.spsInputPerAntimatter.get() * 2L;
    }

    @Override
    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        double processed = 0.0;
        this.couldOperate = this.canOperate();
        if (this.couldOperate && !this.receivedEnergy.isZero()) {
            double lastProgress = this.progress;
            int inputPerAntimatter = MekanismConfig.general.spsInputPerAntimatter.get();
            long inputNeeded = (long)(inputPerAntimatter - this.inputProcessed) + (long)inputPerAntimatter * (this.outputTank.getNeeded() - 1L);
            double processable = this.receivedEnergy.doubleValue() / ((FloatingLong)MekanismConfig.general.spsEnergyPerInput.get()).doubleValue();
            if (processable + this.progress >= (double)inputNeeded) {
                processed = this.process(inputNeeded);
                this.progress = 0.0;
            } else {
                processed = processable;
                this.progress += processable;
                long toProcess = MathUtils.clampToLong(this.progress);
                long actualProcessed = this.process(toProcess);
                if (actualProcessed < toProcess) {
                    long processedDif = toProcess - actualProcessed;
                    this.progress -= (double)processedDif;
                    processed -= (double)processedDif;
                }
                this.progress %= 1.0;
            }
            if (lastProgress != this.progress) {
                this.markDirty();
            }
        }
        if (!this.receivedEnergy.equals(this.lastReceivedEnergy) || processed != this.lastProcessed) {
            needsPacket = true;
        }
        if (!this.gasOutputTargets.isEmpty() && !this.outputTank.isEmpty()) {
            ChemicalUtil.emit(this.getActiveOutputs(this.gasOutputTargets), this.outputTank);
        }
        this.lastReceivedEnergy = this.receivedEnergy;
        this.receivedEnergy = FloatingLong.ZERO;
        this.lastProcessed = processed;
        this.kill(world);
        return needsPacket |= this.coilData.tick();
    }

    @Override
    protected void updateEjectors(Level world) {
        this.gasOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntitySPSPort tile = WorldUtils.getTileEntity(TileEntitySPSPort.class, (BlockGetter)world, valve.location);
            if (tile == null) continue;
            tile.addGasTargetCapability(this.gasOutputTargets, valve.side);
        }
    }

    @Override
    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.readUpdateTag(tag, provider);
        this.coilData.read(tag);
        this.lastReceivedEnergy = FloatingLong.parseFloatingLong(tag.getString("energy_usage"));
        this.lastProcessed = tag.getDouble("last_processed");
    }

    @Override
    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeUpdateTag(tag, provider);
        this.coilData.write(tag);
        tag.putString("energy_usage", this.lastReceivedEnergy.toString());
        tag.putDouble("last_processed", this.lastProcessed);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getCapacity());
    }

    private long process(long operations) {
        if (operations == 0L) {
            return 0L;
        }
        long processed = this.inputTank.shrinkStack(operations, Action.EXECUTE);
        int lastInputProcessed = this.inputProcessed;
        this.inputProcessed += MathUtils.clampToInt(processed);
        int inputPerAntimatter = MekanismConfig.general.spsInputPerAntimatter.get();
        if (this.inputProcessed >= inputPerAntimatter) {
            GasStack toAdd = MekanismGases.ANTIMATTER.getStack(this.inputProcessed / inputPerAntimatter);
            this.outputTank.insert(toAdd, Action.EXECUTE, AutomationType.INTERNAL);
            this.inputProcessed %= inputPerAntimatter;
        }
        if (lastInputProcessed != this.inputProcessed) {
            this.markDirty();
        }
        return processed;
    }

    private void kill(Level world) {
        if (!this.lastReceivedEnergy.isZero() && this.couldOperate && world.getRandom().nextInt() % 20 == 0) {
            List entitiesToDie = this.getLevel().getEntitiesOfClass(Entity.class, this.deathZone);
            for (Entity entity : entitiesToDie) {
                entity.hurt(entity.damageSources().magic(), this.lastReceivedEnergy.floatValue() / 1000.0f);
            }
        }
    }

    public boolean canSupplyCoilEnergy(TileEntitySPSPort tile) {
        return (this.couldOperate || this.canOperate()) && this.coilData.coilMap.containsKey(tile.getBlockPos());
    }

    public void addCoil(BlockPos portPos, Direction side) {
        this.coilData.coilMap.put(portPos, new CoilData(portPos, side));
    }

    public void supplyCoilEnergy(TileEntitySPSPort tile, FloatingLong energy) {
        this.receivedEnergy = this.receivedEnergy.plusEqual(energy);
        this.coilData.coilMap.get(tile.getBlockPos()).receiveEnergy(energy);
    }

    private boolean canOperate() {
        return !this.inputTank.isEmpty() && this.outputTank.getNeeded() > 0L;
    }

    private static int getCoilLevel(FloatingLong energy) {
        if (energy.isZero()) {
            return 0;
        }
        return 1 + Math.max(0, (int)((Math.log10(energy.doubleValue()) - 3.0) * 1.8));
    }

    @ComputerMethod
    public double getProcessRate() {
        return (double)Math.round(this.lastProcessed / (double)MekanismConfig.general.spsInputPerAntimatter.get() * 1000.0) / 1000.0;
    }

    public double getScaledProgress() {
        return ((double)this.inputProcessed + this.progress) / (double)MekanismConfig.general.spsInputPerAntimatter.get();
    }

    public boolean handlesSound(TileEntitySPSCasing tile) {
        return tile.getBlockPos().equals((Object)this.getMinPos().offset(3, 0, 0)) || tile.getBlockPos().equals((Object)this.getMaxPos().offset(-3, 0, 0));
    }

    @ComputerMethod
    int getCoils() {
        return this.coilData.coilMap.size();
    }

    public static class SyncableCoilData {
        public final Map<BlockPos, CoilData> coilMap = new Object2ObjectOpenHashMap();
        public int prevHash;

        private boolean tick() {
            for (CoilData data : this.coilMap.values()) {
                data.prevLevel = data.laserLevel;
                data.laserLevel = 0;
            }
            int newHash = this.coilMap.hashCode();
            boolean ret = newHash != this.prevHash;
            this.prevHash = newHash;
            return ret;
        }

        public void write(CompoundTag tags) {
            ListTag list = new ListTag();
            for (CoilData data : this.coilMap.values()) {
                CompoundTag tag = new CompoundTag();
                tag.put("position", NbtUtils.writeBlockPos((BlockPos)data.coilPos));
                NBTUtils.writeEnum(tag, "side", data.side);
                tag.putInt("level", data.prevLevel);
                list.add((Object)tag);
            }
            tags.put("coils", (Tag)list);
        }

        public void read(CompoundTag tags) {
            this.coilMap.clear();
            ListTag list = tags.getList("coils", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.getCompound(i);
                Optional pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"position");
                if (!pos.isPresent()) continue;
                Direction side = Direction.from3DDataValue((int)tag.getInt("side"));
                CoilData data = new CoilData((BlockPos)pos.get(), side);
                data.prevLevel = tag.getInt("level");
                this.coilMap.put(data.coilPos, data);
            }
        }
    }

    public static class CoilData {
        public final BlockPos coilPos;
        public final Direction side;
        public int prevLevel;
        private int laserLevel;

        private CoilData(BlockPos pos, Direction side) {
            this.coilPos = pos;
            this.side = side;
        }

        private void receiveEnergy(FloatingLong energy) {
            this.laserLevel += SPSMultiblockData.getCoilLevel(energy);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.coilPos.hashCode();
            result = 31 * result + this.prevLevel;
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CoilData)) return false;
            CoilData other = (CoilData)o;
            if (!this.coilPos.equals((Object)other.coilPos)) return false;
            if (this.prevLevel != other.prevLevel) return false;
            return true;
        }
    }
}

