/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.sps;

import mekanism.api.math.FloatingLong;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class SPSCache
extends MultiblockCache<SPSMultiblockData> {
    private double progress;
    private int inputProcessed;
    private boolean couldOperate;
    private FloatingLong receivedEnergy = FloatingLong.ZERO;
    private double lastProcessed;

    @Override
    public void merge(MultiblockCache<SPSMultiblockData> mergeCache, MultiblockCache.RejectContents rejectContents) {
        super.merge(mergeCache, rejectContents);
        this.progress += ((SPSCache)mergeCache).progress;
        this.inputProcessed += ((SPSCache)mergeCache).inputProcessed;
        this.couldOperate |= ((SPSCache)mergeCache).couldOperate;
        this.receivedEnergy = this.receivedEnergy.add(((SPSCache)mergeCache).receivedEnergy);
        this.lastProcessed = Math.max(this.lastProcessed, ((SPSCache)mergeCache).lastProcessed);
    }

    @Override
    public void apply(HolderLookup.Provider provider, SPSMultiblockData data) {
        super.apply(provider, data);
        data.progress = this.progress;
        data.inputProcessed = this.inputProcessed;
        data.couldOperate = this.couldOperate;
        data.receivedEnergy = this.receivedEnergy;
        data.lastProcessed = this.lastProcessed;
    }

    @Override
    public void sync(SPSMultiblockData data) {
        super.sync(data);
        this.progress = data.progress;
        this.inputProcessed = data.inputProcessed;
        this.couldOperate = data.couldOperate;
        this.receivedEnergy = data.receivedEnergy;
        this.lastProcessed = data.lastProcessed;
    }

    @Override
    public void load(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.load(provider, nbtTags);
        NBTUtils.setDoubleIfPresent(nbtTags, "progress", val -> {
            this.progress = val;
        });
        NBTUtils.setIntIfPresent(nbtTags, "processed", val -> {
            this.inputProcessed = val;
        });
        NBTUtils.setBooleanIfPresent(nbtTags, "could_operate", val -> {
            this.couldOperate = val;
        });
        NBTUtils.setFloatingLongIfPresent(nbtTags, "energy_usage", val -> {
            this.receivedEnergy = val;
        });
        NBTUtils.setDoubleIfPresent(nbtTags, "last_processed", val -> {
            this.lastProcessed = val;
        });
    }

    @Override
    public void save(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.save(provider, nbtTags);
        nbtTags.putDouble("progress", this.progress);
        nbtTags.putInt("processed", this.inputProcessed);
        nbtTags.putBoolean("could_operate", this.couldOperate);
        nbtTags.putString("energy_usage", this.receivedEnergy.toString());
        nbtTags.putDouble("last_processed", this.lastProcessed);
    }
}

