/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowOutputInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.crafting.IShapedRecipe;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIOCraftingWindow
implements IContentsListener {
    private static final SelectedWindowData[] WINDOWS = new SelectedWindowData[3];
    private final IInventorySlot[] inputSlots = new CraftingWindowInventorySlot[9];
    private final ReplacementHelper replacementHelper = new ReplacementHelper();
    private final RemainderHelper remainderHelper = new RemainderHelper();
    private final IInventorySlot outputSlot;
    private final IQIOCraftingWindowHolder holder;
    private final SelectedWindowData windowData;
    private final byte windowIndex;
    @Nullable
    private RecipeHolder<CraftingRecipe> lastRecipe;
    private boolean isCrafting;
    private boolean changedWhileCrafting;

    public QIOCraftingWindow(IQIOCraftingWindowHolder holder, byte windowIndex) {
        this.windowIndex = windowIndex;
        this.holder = holder;
        this.windowData = WINDOWS[windowIndex];
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.inputSlots[slotIndex] = CraftingWindowInventorySlot.input(this, this.holder);
        }
        this.outputSlot = CraftingWindowOutputInventorySlot.create(this);
    }

    public QIOCraftingWindow(IQIOCraftingWindowHolder holder, byte windowIndex, IntFunction<IContentsListener> inputSaveListener) {
        this.windowIndex = windowIndex;
        this.holder = holder;
        this.windowData = WINDOWS[windowIndex];
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.inputSlots[slotIndex] = CraftingWindowInventorySlot.input(this, inputSaveListener.apply(slotIndex));
        }
        this.outputSlot = CraftingWindowOutputInventorySlot.create(this);
    }

    public SelectedWindowData getWindowData() {
        return this.windowData;
    }

    public byte getWindowIndex() {
        return this.windowIndex;
    }

    public IInventorySlot getInputSlot(int slot) {
        if (slot < 0 || slot >= 9) {
            throw new IllegalArgumentException("Input slot out of range");
        }
        return this.inputSlots[slot];
    }

    public IInventorySlot getOutputSlot() {
        return this.outputSlot;
    }

    public boolean isOutput(@NotNull ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.outputSlot.getStack(), (ItemStack)stack);
    }

    @Override
    public void onContentsChanged() {
        if (this.isCrafting) {
            this.changedWhileCrafting = true;
        } else {
            Level world = this.holder.getLevel();
            if (world != null && !world.isClientSide) {
                this.updateOutputSlot(world);
            }
        }
    }

    public void invalidateRecipe() {
        Level world;
        this.lastRecipe = null;
        if (!this.outputSlot.isEmpty()) {
            this.outputSlot.setEmpty();
        }
        if ((world = this.holder.getLevel()) != null && !world.isClientSide) {
            this.updateOutputSlot(world);
        }
    }

    private void updateOutputSlot(@NotNull Level world) {
        if (world.getServer() != null) {
            CraftingInput craftingInput = this.asCraftingInput().input();
            if (craftingInput.isEmpty()) {
                if (!this.outputSlot.isEmpty()) {
                    this.outputSlot.setEmpty();
                }
            } else if (this.lastRecipe != null && ((CraftingRecipe)this.lastRecipe.value()).matches((RecipeInput)craftingInput, world)) {
                this.outputSlot.setStack(this.assembleRecipe(craftingInput, (CraftingRecipe)this.lastRecipe.value(), world.registryAccess()));
            } else {
                RecipeHolder recipe = MekanismRecipeType.getRecipeFor(RecipeType.CRAFTING, craftingInput, world).orElse(null);
                if (!Objects.equals(recipe, this.lastRecipe)) {
                    if (recipe == null) {
                        if (!this.outputSlot.isEmpty()) {
                            this.outputSlot.setEmpty();
                        }
                    } else {
                        this.lastRecipe = recipe;
                        this.outputSlot.setStack(this.assembleRecipe(craftingInput, (CraftingRecipe)this.lastRecipe.value(), world.registryAccess()));
                    }
                }
            }
        }
    }

    private ItemStack assembleRecipe(CraftingInput craftingInput, CraftingRecipe recipe, RegistryAccess registryAccess) {
        return recipe.assemble((RecipeInput)craftingInput, (HolderLookup.Provider)registryAccess);
    }

    public boolean canViewRecipe(@NotNull ServerPlayer player) {
        if (this.lastRecipe == null) {
            return false;
        }
        return ((CraftingRecipe)this.lastRecipe.value()).isSpecial() || !player.level().getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || player.getRecipeBook().contains(this.lastRecipe);
    }

    @Contract(value="null, _, _ -> false")
    private boolean validateAndUnlockRecipe(@Nullable Level world, @NotNull Player player, CraftingInput craftingInput) {
        if (world == null || this.lastRecipe == null || !((CraftingRecipe)this.lastRecipe.value()).matches((RecipeInput)craftingInput, world)) {
            return false;
        }
        if (this.lastRecipe != null) {
            player.triggerRecipeCrafted(this.lastRecipe, craftingInput.items());
            if (!((CraftingRecipe)this.lastRecipe.value()).isSpecial()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (world.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) && !serverPlayer.getRecipeBook().contains(this.lastRecipe)) {
                        return false;
                    }
                }
                player.awardRecipes(Collections.singleton(this.lastRecipe));
            }
        }
        return true;
    }

    private void craftingStarted(@NotNull Player player) {
        this.isCrafting = true;
        CommonHooks.setCraftingPlayer((Player)player);
    }

    private void craftingFinished(@NotNull Level world) {
        CommonHooks.setCraftingPlayer(null);
        this.isCrafting = false;
        if (this.changedWhileCrafting) {
            this.changedWhileCrafting = false;
            this.updateOutputSlot(world);
        }
    }

    private int calculateMaxCraftAmount(@NotNull ItemStack stack, @Nullable QIOFrequency frequency) {
        IInventorySlot inputSlot;
        int count;
        int outputSize = stack.getCount();
        int inputSize = 99;
        IInventorySlot[] iInventorySlotArray = this.inputSlots;
        int n = iInventorySlotArray.length;
        for (int i = 0; i < n && ((count = (inputSlot = iInventorySlotArray[i]).getCount()) <= 0 || count >= inputSize || (inputSize = count) != 1); ++i) {
        }
        if (inputSize > 1) {
            return inputSize * outputSize;
        }
        if (frequency == null) {
            return outputSize;
        }
        int maxToCraft = stack.getMaxStackSize();
        if (outputSize < maxToCraft) {
            maxToCraft -= maxToCraft % outputSize;
        }
        return maxToCraft;
    }

    private void useInput(IInventorySlot inputSlot) {
        MekanismUtils.logMismatchedStackSize(inputSlot.shrinkStack(1, Action.EXECUTE), 1L);
    }

    public void emptyTo(boolean toPlayerInv, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        block3: {
            block2: {
                if (!toPlayerInv) break block2;
                for (IInventorySlot inputSlot : this.inputSlots) {
                    ItemStack toTransfer;
                    if (inputSlot.isEmpty() || (toTransfer = inputSlot.extractItem(inputSlot.getCount(), Action.SIMULATE, AutomationType.INTERNAL)).isEmpty()) continue;
                    ItemStack remainder = MekanismContainer.insertItem(hotBarSlots, toTransfer, true, this.windowData);
                    remainder = MekanismContainer.insertItem(mainInventorySlots, remainder, true, this.windowData);
                    remainder = MekanismContainer.insertItem(hotBarSlots, remainder, false, this.windowData);
                    remainder = MekanismContainer.insertItem(mainInventorySlots, remainder, false, this.windowData);
                    inputSlot.extractItem(toTransfer.getCount() - remainder.getCount(), Action.EXECUTE, AutomationType.INTERNAL);
                }
                break block3;
            }
            QIOFrequency frequency = this.holder.getFrequency();
            if (frequency == null) break block3;
            for (IInventorySlot inputSlot : this.inputSlots) {
                ItemStack toTransfer;
                if (inputSlot.isEmpty() || (toTransfer = inputSlot.extractItem(inputSlot.getCount(), Action.SIMULATE, AutomationType.INTERNAL)).isEmpty()) continue;
                ItemStack remainder = frequency.addItem(toTransfer);
                inputSlot.extractItem(toTransfer.getCount() - remainder.getCount(), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }
    }

    public void performCraft(@NotNull Player player, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        int crafted;
        CraftingInput.Positioned craftingInput;
        if (this.lastRecipe == null || this.outputSlot.isEmpty()) {
            return;
        }
        Level world = this.holder.getLevel();
        if (!this.validateAndUnlockRecipe(world, player, (craftingInput = this.asCraftingInput()).input())) {
            return;
        }
        QIOFrequency frequency = this.holder.getFrequency();
        this.craftingStarted(player);
        ItemStack result = this.outputSlot.getStack().copy();
        Item resultItem = result.getItem();
        resultItem.onCraftedBy(result, world, player);
        Stat itemCraftedStat = Stats.ITEM_CRAFTED.get((Object)resultItem);
        int maxToCraft = this.calculateMaxCraftAmount(result, frequency);
        int amountPerCraft = result.getCount();
        this.remainderHelper.reset();
        this.replacementHelper.reset();
        boolean recheckOutput = false;
        LastInsertTarget lastInsertTarget = new LastInsertTarget();
        NonNullList remaining = ((CraftingRecipe)this.lastRecipe.value()).getRemainingItems((RecipeInput)craftingInput.input());
        for (crafted = 0; crafted < maxToCraft; crafted += amountPerCraft) {
            if (recheckOutput && this.changedWhileCrafting) {
                ItemStack updatedOutput;
                recheckOutput = false;
                this.changedWhileCrafting = false;
                RecipeHolder<CraftingRecipe> oldRecipe = this.lastRecipe;
                this.updateOutputSlot(world);
                if (!Objects.equals(oldRecipe, this.lastRecipe) || (updatedOutput = this.outputSlot.getStack()).isEmpty() || updatedOutput.getItem() != resultItem) break;
                ItemStack potentialUpdatedOutput = updatedOutput.copy();
                resultItem.onCraftedBy(potentialUpdatedOutput, world, player);
                if (!ItemStack.matches((ItemStack)result, (ItemStack)potentialUpdatedOutput)) break;
                craftingInput = this.asCraftingInput();
                remaining = ((CraftingRecipe)this.lastRecipe.value()).getRemainingItems((RecipeInput)craftingInput.input());
            }
            ItemStack simulatedRemainder = MekanismContainer.insertItemCheckAll(hotBarSlots, result, this.windowData, Action.SIMULATE);
            if (!(simulatedRemainder = MekanismContainer.insertItemCheckAll(mainInventorySlots, simulatedRemainder, this.windowData, Action.SIMULATE)).isEmpty()) break;
            ItemStack toInsert = lastInsertTarget.tryInserting(hotBarSlots, mainInventorySlots, this.windowData, result);
            if (!toInsert.isEmpty()) {
                player.drop(toInsert, false);
            }
            boolean stopCrafting = false;
            int size = remaining.size();
            for (int subIndex = 0; subIndex < size; ++subIndex) {
                ItemStack remainder = (ItemStack)remaining.get(subIndex);
                int index = QIOCraftingWindow.getIndexFromRemaining(craftingInput, subIndex);
                IInventorySlot inputSlot = this.inputSlots[index];
                if (inputSlot.getCount() > 1) {
                    this.useInput(inputSlot);
                } else if (inputSlot.getCount() == 1) {
                    if (frequency == null || this.remainderHelper.isStackStillValid(world, remainder, index)) {
                        this.useInput(inputSlot);
                        recheckOutput = true;
                    } else {
                        ItemStack current = inputSlot.getStack();
                        ItemStack removed = frequency.removeItem(current, 1);
                        if (removed.isEmpty()) {
                            this.useInput(inputSlot);
                            this.replacementHelper.findEquivalentItem(world, frequency, inputSlot, index, current);
                            stopCrafting = true;
                        }
                    }
                } else if (!remainder.isEmpty()) {
                    recheckOutput = true;
                }
                this.addRemainingItem(player, frequency, inputSlot, remainder, true);
            }
            if (!stopCrafting) continue;
            crafted += amountPerCraft;
            break;
        }
        if (crafted > 0) {
            player.awardStat(itemCraftedStat, crafted);
        }
        this.craftingFinished(world);
    }

    private static int getIndexFromRemaining(CraftingInput.Positioned craftingInput, int subIndex) {
        int width = craftingInput.input().width();
        int height = craftingInput.input().height();
        int row = craftingInput.top() + subIndex / width % height;
        int column = craftingInput.left() + subIndex % width;
        return 3 * row + column;
    }

    @NotNull
    public ItemStack performCraft(@NotNull Player player, @NotNull ItemStack result, int amountCrafted) {
        CraftingInput.Positioned craftingInput;
        if (amountCrafted == 0 || this.lastRecipe == null || result.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Level world = this.holder.getLevel();
        if (!this.validateAndUnlockRecipe(world, player, (craftingInput = this.asCraftingInput()).input())) {
            return ItemStack.EMPTY;
        }
        QIOFrequency frequency = this.holder.getFrequency();
        this.craftingStarted(player);
        result.onCraftedBy(world, player, amountCrafted);
        NonNullList remaining = ((CraftingRecipe)this.lastRecipe.value()).getRemainingItems((RecipeInput)craftingInput.input());
        this.remainderHelper.reset();
        this.replacementHelper.reset();
        int size = remaining.size();
        for (int subIndex = 0; subIndex < size; ++subIndex) {
            ItemStack remainder = (ItemStack)remaining.get(subIndex);
            int index = QIOCraftingWindow.getIndexFromRemaining(craftingInput, subIndex);
            IInventorySlot inputSlot = this.inputSlots[index];
            if (inputSlot.getCount() > 1) {
                this.useInput(inputSlot);
            } else if (inputSlot.getCount() == 1) {
                if (frequency == null || this.remainderHelper.isStackStillValid(world, remainder, index)) {
                    this.useInput(inputSlot);
                } else {
                    ItemStack current = inputSlot.getStack();
                    ItemStack removed = frequency.removeItem(current, 1);
                    if (removed.isEmpty()) {
                        this.useInput(inputSlot);
                        this.replacementHelper.findEquivalentItem(world, frequency, inputSlot, index, current);
                    }
                }
            }
            this.addRemainingItem(player, frequency, inputSlot, remainder, false);
        }
        this.craftingFinished(world);
        return result;
    }

    private void addRemainingItem(Player player, @Nullable QIOFrequency frequency, IInventorySlot slot, @NotNull ItemStack remainder, boolean copyIfNeeded) {
        int toInsert = remainder.getCount();
        if (!(remainder = slot.insertItem(remainder, Action.EXECUTE, AutomationType.INTERNAL)).isEmpty()) {
            if (copyIfNeeded && toInsert == remainder.getCount()) {
                remainder = remainder.copy();
            }
            if (!player.getInventory().add(remainder)) {
                if (frequency != null && (remainder = frequency.addItem(remainder)).isEmpty()) {
                    return;
                }
                player.drop(remainder, false);
            }
        }
    }

    private CraftingInput.Positioned asCraftingInput() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(9);
        for (IInventorySlot inputSlot : this.inputSlots) {
            items.add(inputSlot.getStack().copyWithCount(1));
        }
        return CraftingInput.ofPositioned((int)3, (int)3, items);
    }

    static {
        for (byte tableIndex = 0; tableIndex < WINDOWS.length; tableIndex = (byte)(tableIndex + 1)) {
            QIOCraftingWindow.WINDOWS[tableIndex] = new SelectedWindowData(SelectedWindowData.WindowType.CRAFTING, tableIndex);
        }
    }

    private class ReplacementHelper {
        private final Int2ObjectMap<Ingredient> slotIngredients;
        private boolean mapped;
        private boolean invalid;

        private ReplacementHelper() {
            this.slotIngredients = new Int2ObjectArrayMap(QIOCraftingWindow.this.inputSlots.length);
        }

        public void reset() {
            if (this.mapped) {
                this.mapped = false;
                this.invalid = false;
                this.slotIngredients.clear();
            }
        }

        public void findEquivalentItem(Level world, @NotNull QIOFrequency frequency, IInventorySlot slot, int index, ItemStack used) {
            this.mapRecipe(index, used);
            if (this.invalid) {
                return;
            }
            Ingredient usedIngredient = (Ingredient)this.slotIngredients.getOrDefault(index, (Object)Ingredient.EMPTY);
            if (usedIngredient.test(used)) {
                for (ItemStack item : usedIngredient.getItems()) {
                    if (item.isEmpty()) continue;
                    if (this.testEquivalentItem(world, frequency, slot, index, usedIngredient, HashedItem.raw(item))) {
                        return;
                    }
                    for (HashedItem type : frequency.getTypesForItem(item.getItem())) {
                        if (!this.testEquivalentItem(world, frequency, slot, index, usedIngredient, type)) continue;
                        return;
                    }
                }
            }
        }

        private boolean testEquivalentItem(Level world, @NotNull QIOFrequency frequency, IInventorySlot slot, int index, Ingredient usedIngredient, HashedItem replacementType) {
            if (!frequency.isStoring(replacementType) || !usedIngredient.test(replacementType.getInternalStack())) {
                return false;
            }
            ItemStack replacement = replacementType.createStack(1);
            ItemStack old = (ItemStack)QIOCraftingWindow.this.remainderHelper.dummy.get(index);
            if (QIOCraftingWindow.this.remainderHelper.isStackStillValid(world, replacement, index)) {
                ItemStack removed;
                if (slot.insertItem(replacement, Action.SIMULATE, AutomationType.INTERNAL).isEmpty() && !(removed = frequency.removeByType(replacementType, 1)).isEmpty()) {
                    ItemStack stack = slot.insertItem(removed, Action.EXECUTE, AutomationType.INTERNAL);
                    if (!stack.isEmpty()) {
                        Mekanism.logger.error("Failed to insert item ({} with components: {}) into crafting window: {}.", new Object[]{removed.getItem(), removed.getComponentsPatch(), QIOCraftingWindow.this.windowIndex});
                    }
                    return true;
                }
                QIOCraftingWindow.this.remainderHelper.dummy.set(index, (Object)old);
            }
            return false;
        }

        private void mapRecipe(int index, ItemStack used) {
            if (!this.mapped) {
                this.mapped = true;
                if (QIOCraftingWindow.this.lastRecipe == null || ((CraftingRecipe)QIOCraftingWindow.this.lastRecipe.value()).isSpecial()) {
                    this.invalid = true;
                    return;
                }
                NonNullList ingredients = ((CraftingRecipe)QIOCraftingWindow.this.lastRecipe.value()).getIngredients();
                if (ingredients.isEmpty()) {
                    this.invalid = true;
                    return;
                }
                QIOCraftingWindow.this.remainderHelper.updateInputsWithReplacement(index, used);
                Recipe recipe = QIOCraftingWindow.this.lastRecipe.value();
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
                    this.mapShapedRecipe(shapedRecipe, (NonNullList<Ingredient>)ingredients, index, used);
                } else {
                    this.mapShapelessRecipe((NonNullList<Ingredient>)ingredients, index, used);
                }
            }
        }

        private ItemStack getItem(int i, int index, ItemStack used) {
            if (i == index) {
                return used;
            }
            if (i >= 0 && i < QIOCraftingWindow.this.inputSlots.length) {
                return QIOCraftingWindow.this.inputSlots[i].getStack();
            }
            return ItemStack.EMPTY;
        }

        private void mapShapedRecipe(IShapedRecipe<?> shapedRecipe, NonNullList<Ingredient> ingredients, int index, ItemStack used) {
            int recipeWidth = shapedRecipe.getWidth();
            int recipeHeight = shapedRecipe.getHeight();
            for (int columnStart = 0; columnStart <= 3 - recipeWidth; ++columnStart) {
                for (int rowStart = 0; rowStart <= 3 - recipeHeight; ++rowStart) {
                    if (!this.mapShapedRecipe(ingredients, columnStart, rowStart, recipeWidth, recipeHeight, true, index, used) && !this.mapShapedRecipe(ingredients, columnStart, rowStart, recipeWidth, recipeHeight, false, index, used)) continue;
                    return;
                }
            }
            this.invalid = true;
        }

        private boolean mapShapedRecipe(NonNullList<Ingredient> ingredients, int columnStart, int rowStart, int recipeWidth, int recipeHeight, boolean mirrored, int index, ItemStack used) {
            for (int actualColumn = 0; actualColumn < 3; ++actualColumn) {
                for (int actualRow = 0; actualRow < 3; ++actualRow) {
                    int i;
                    int column = actualColumn - columnStart;
                    int row = actualRow - rowStart;
                    Ingredient ingredient = Ingredient.EMPTY;
                    if (column >= 0 && row >= 0 && column < recipeWidth && row < recipeHeight) {
                        ingredient = mirrored ? (Ingredient)ingredients.get(recipeWidth - column - 1 + row * recipeWidth) : (Ingredient)ingredients.get(column + row * recipeWidth);
                    }
                    if (!ingredient.test(this.getItem(i = actualColumn + actualRow * 3, index, used))) {
                        this.slotIngredients.clear();
                        return false;
                    }
                    this.slotIngredients.put(i, (Object)ingredient);
                }
            }
            return true;
        }

        private void mapShapelessRecipe(NonNullList<Ingredient> ingredients, int index, ItemStack used) {
            Int2IntArrayMap actualLookup = new Int2IntArrayMap(QIOCraftingWindow.this.inputSlots.length);
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(QIOCraftingWindow.this.inputSlots.length);
            for (int i = 0; i < QIOCraftingWindow.this.inputSlots.length; ++i) {
                ItemStack stack = this.getItem(i, index, used);
                if (stack.isEmpty()) continue;
                actualLookup.put(inputs.size(), i);
                inputs.add(stack);
            }
            int[] matches = RecipeMatcher.findMatches(inputs, ingredients);
            if (matches != null) {
                for (int ingredientIndex = 0; ingredientIndex < matches.length; ++ingredientIndex) {
                    int actualSlot = actualLookup.getOrDefault(matches[ingredientIndex], -1);
                    if (actualSlot == -1) {
                        this.invalid = true;
                        return;
                    }
                    this.slotIngredients.put(actualSlot, (Object)((Ingredient)ingredients.get(ingredientIndex)));
                }
            } else {
                this.invalid = true;
            }
        }
    }

    private class RemainderHelper {
        private final NonNullList<ItemStack> dummy = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        private boolean updated;

        private RemainderHelper() {
        }

        public void reset() {
            if (this.updated) {
                this.updated = false;
                this.dummy.clear();
            }
        }

        private void updateInputs(@NotNull ItemStack remainder) {
            if (!this.updated && !remainder.isEmpty()) {
                for (int index = 0; index < QIOCraftingWindow.this.inputSlots.length; ++index) {
                    this.dummy.set(index, (Object)QIOCraftingWindow.this.inputSlots[index].getStack().copyWithCount(1));
                }
                this.updated = true;
            }
        }

        public void updateInputsWithReplacement(int index, ItemStack old) {
            if (!this.updated) {
                for (int i = 0; i < QIOCraftingWindow.this.inputSlots.length; ++i) {
                    ItemStack stack = i == index ? old : QIOCraftingWindow.this.inputSlots[i].getStack();
                    this.dummy.set(i, (Object)stack.copyWithCount(1));
                }
                this.updated = true;
            }
        }

        public boolean isStackStillValid(Level world, ItemStack stack, int index) {
            this.updateInputs(stack);
            ItemStack old = (ItemStack)this.dummy.get(index);
            this.dummy.set(index, (Object)stack.copyWithCount(1));
            if (QIOCraftingWindow.this.lastRecipe != null && ((CraftingRecipe)QIOCraftingWindow.this.lastRecipe.value()).matches((RecipeInput)CraftingInput.of((int)3, (int)3, this.dummy), world)) {
                return true;
            }
            this.dummy.set(index, (Object)old);
            return false;
        }
    }

    private static class LastInsertTarget {
        private boolean wasHotBar = true;
        private int lastIndex;

        private LastInsertTarget() {
        }

        public ItemStack tryInserting(List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, SelectedWindowData windowData, ItemStack toInsert) {
            toInsert = this.insertItem(hotBarSlots, toInsert, true, true, windowData);
            toInsert = this.insertItem(mainInventorySlots, toInsert, true, false, windowData);
            toInsert = this.insertItem(hotBarSlots, toInsert, false, true, windowData);
            toInsert = this.insertItem(mainInventorySlots, toInsert, false, false, windowData);
            return toInsert;
        }

        @NotNull
        private <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty, boolean isHotBar, @Nullable SelectedWindowData selectedWindow) {
            if (stack.isEmpty()) {
                return stack;
            }
            int slotCount = slots.size();
            for (int i = ignoreEmpty && this.wasHotBar == isHotBar ? this.lastIndex : 0; i < slotCount; ++i) {
                Slot slot = (Slot)slots.get(i);
                if (ignoreEmpty != slot.hasItem() || !((IInsertableSlot)slot).exists(selectedWindow) || !(stack = ((IInsertableSlot)slot).insertItem(stack, Action.EXECUTE)).isEmpty()) continue;
                this.wasHotBar = isHotBar;
                this.lastIndex = i;
                break;
            }
            return stack;
        }
    }
}

