/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.registries.MekanismModules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class ModuleShearingUnit
implements ICustomModule<ModuleShearingUnit> {
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.isSpectator() && entity instanceof IShearable;

    @Override
    public boolean canPerformAction(IModule<ModuleShearingUnit> module, IModuleContainer container, ItemStack stack, ItemAbility action) {
        if (action == ItemAbilities.SHEARS_DISARM) {
            if (stack.getItem() instanceof ItemMekaTool) {
                FloatingLong cost = ItemMekaTool.getDestroyEnergy(container, 0.0f, container.hasEnabled(MekanismModules.SILK_TOUCH_UNIT));
                return module.hasEnoughEnergy(stack, cost);
            }
            return true;
        }
        if (action == ItemAbilities.SHEARS_DIG) {
            return !(stack.getItem() instanceof ItemMekaTool) || ItemMekaTool.hasEnergyForDigAction(container, module.getEnergyContainer(stack));
        }
        return ItemAbilities.DEFAULT_SHEARS_ACTIONS.contains(action);
    }

    @Override
    @NotNull
    public InteractionResult onInteract(IModule<ModuleShearingUnit> module, Player player, LivingEntity entity, InteractionHand hand, IModuleContainer moduleContainer, ItemStack stack) {
        if (entity instanceof IShearable) {
            FloatingLong cost = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get();
            IEnergyContainer energyContainer = module.getEnergyContainer(stack);
            if (cost.isZero() || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(cost) && this.shearEntity(energyContainer, entity, player, stack, entity.level(), entity.blockPosition())) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public ICustomModule.ModuleDispenseResult onDispense(IModule<ModuleShearingUnit> module, IModuleContainer moduleContainer, ItemStack stack, BlockSource source) {
        ServerLevel world = source.level();
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos pos = source.pos().relative(facing);
        if (this.tryShearBlock(world, pos, facing.getOpposite()) || this.tryShearLivingEntity(module.getEnergyContainer(stack), world, pos, stack)) {
            return ICustomModule.ModuleDispenseResult.HANDLED;
        }
        return ICustomModule.ModuleDispenseResult.FAIL_PREVENT_DROP;
    }

    private boolean tryShearBlock(ServerLevel world, BlockPos pos, Direction sideClicked) {
        Block block;
        BlockState state = world.getBlockState(pos);
        if (state.is(BlockTags.BEEHIVES) && (block = state.getBlock()) instanceof BeehiveBlock) {
            BeehiveBlock beehive = (BeehiveBlock)block;
            if ((Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= 5) {
                world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                BeehiveBlock.dropHoneycomb((Level)world, (BlockPos)pos);
                beehive.releaseBeesAndResetHoneyLevel((Level)world, state, pos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                return true;
            }
        }
        if (state.is(Blocks.PUMPKIN)) {
            Direction side = sideClicked.getAxis() == Direction.Axis.Y ? Direction.NORTH : sideClicked;
            world.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.setBlock(pos, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)side), 11);
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.PUMPKIN_SEEDS, 4));
            return true;
        }
        return false;
    }

    private boolean tryShearLivingEntity(@Nullable IEnergyContainer energyContainer, ServerLevel world, BlockPos pos, ItemStack stack) {
        FloatingLong cost = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get();
        if (cost.isZero() || energyContainer != null && energyContainer.getEnergy().greaterOrEqual((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get())) {
            for (LivingEntity entity : world.getEntitiesOfClass(LivingEntity.class, new AABB(pos), SHEARABLE)) {
                if (!this.shearEntity(energyContainer, entity, null, stack, (Level)world, pos)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shearEntity(@Nullable IEnergyContainer energyContainer, LivingEntity entity, @Nullable Player player, ItemStack stack, Level world, BlockPos pos) {
        IShearable target = (IShearable)entity;
        if (target.isShearable(player, stack, world, pos)) {
            if (!world.isClientSide) {
                for (ItemStack drop : target.onSheared(player, stack, world, pos)) {
                    target.spawnShearedDrop(world, pos, drop);
                }
                entity.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                if (energyContainer != null) {
                    energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get(), Action.EXECUTE, AutomationType.MANUAL);
                }
            }
            return true;
        }
        return false;
    }
}

