/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketLightningRender;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public record ModuleFarmingUnit(FarmingRadius farmingRadius) implements ICustomModule<ModuleFarmingUnit>
{
    public static final ResourceLocation FARMING_RADIUS = Mekanism.rl("farming_radius");

    public ModuleFarmingUnit(IModule<ModuleFarmingUnit> module) {
        this((FarmingRadius)module.getConfigOrThrow(FARMING_RADIUS).get());
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(IModule<ModuleFarmingUnit> module, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        int diameter = this.farmingRadius.getRadius();
        if (diameter == 0) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return InteractionResult.FAIL;
        }
        Lazy lazyClickedState = Lazy.of(() -> context.getLevel().getBlockState(context.getClickedPos()));
        return MekanismUtils.performActions(this.useAxeAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, ItemAbilities.AXE_STRIP, SoundEvents.AXE_STRIP, -1), () -> this.useAxeAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, ItemAbilities.AXE_SCRAPE, SoundEvents.AXE_SCRAPE, 3005), () -> this.useAxeAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, ItemAbilities.AXE_WAX_OFF, SoundEvents.AXE_WAX_OFF, 3004), () -> this.flattenAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter), () -> this.dowseCampfire(context, (Lazy<BlockState>)lazyClickedState, energyContainer), () -> this.tillAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter));
    }

    @Override
    public boolean canPerformAction(IModule<ModuleFarmingUnit> module, IModuleContainer moduleContainer, ItemStack stack, ItemAbility action) {
        if (action == ItemAbilities.AXE_STRIP || action == ItemAbilities.AXE_SCRAPE || action == ItemAbilities.AXE_WAX_OFF) {
            return module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaToolEnergyUsageAxe);
        }
        if (action == ItemAbilities.SHOVEL_FLATTEN) {
            return module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaToolEnergyUsageShovel);
        }
        if (action == ItemAbilities.HOE_TILL) {
            return module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaToolEnergyUsageHoe);
        }
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(action) || ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(action) || ItemAbilities.DEFAULT_HOE_ACTIONS.contains(action);
    }

    private InteractionResult dowseCampfire(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer) {
        FloatingLong energyUsage;
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShovel.get())) {
            return InteractionResult.FAIL;
        }
        BlockState clickedState = (BlockState)lazyClickedState.get();
        if (clickedState.getBlock() instanceof CampfireBlock && ((Boolean)clickedState.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            Level world = context.getLevel();
            BlockPos pos = context.getClickedPos();
            if (!world.isClientSide()) {
                world.levelEvent(null, 1009, pos, 0);
            }
            CampfireBlock.dowse((Entity)context.getPlayer(), (LevelAccessor)world, (BlockPos)pos, (BlockState)clickedState);
            if (!world.isClientSide()) {
                world.setBlock(pos, (BlockState)clickedState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.FALSE), 11);
                energyContainer.extract(energyUsage, Action.EXECUTE, AutomationType.MANUAL);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tillAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter) {
        return this.useAOE(context, lazyClickedState, energyContainer, diameter, ItemAbilities.HOE_TILL, SoundEvents.HOE_TILL, -1, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageHoe.get(), new HoeToolAOEData());
    }

    private InteractionResult flattenAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter) {
        Direction sideHit = context.getClickedFace();
        if (sideHit == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        return this.useAOE(context, lazyClickedState, energyContainer, diameter, ItemAbilities.SHOVEL_FLATTEN, SoundEvents.SHOVEL_FLATTEN, -1, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShovel.get(), new ShovelToolAOEData());
    }

    private InteractionResult useAxeAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter, ItemAbility action, SoundEvent sound, int particle) {
        return this.useAOE(context, lazyClickedState, energyContainer, diameter, action, sound, particle, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageAxe.get(), new AxeToolAOEData());
    }

    private InteractionResult useAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter, ItemAbility action, SoundEvent sound, int particle, FloatingLong energyUsage, IToolAOEData toolAOEData) {
        BlockState clickedState;
        BlockPos pos;
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        if (!toolAOEData.isValid(world, pos = context.getClickedPos(), clickedState = (BlockState)lazyClickedState.get())) {
            return InteractionResult.PASS;
        }
        BlockState modifiedState = clickedState.getToolModifiedState(context, action, false);
        if (modifiedState == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer player = null;
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            player = serverPlayer = (ServerPlayer)player2;
        }
        if (player != null) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, pos, context.getItemInHand());
        }
        world.setBlock(pos, modifiedState, 11);
        world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (particle != -1) {
            world.levelEvent(null, particle, pos, 0);
        }
        Direction side = context.getClickedFace();
        toolAOEData.persistData(world, pos, clickedState, side);
        FloatingLong energyUsed = energyUsage;
        for (BlockPos newPos : toolAOEData.getTargetPositions(pos, side, (diameter - 1) / 2)) {
            if (pos.equals((Object)newPos)) continue;
            FloatingLong nextEnergyUsed = energyUsed.add(energyUsage);
            if (nextEnergyUsed.greaterThan(energy)) break;
            BlockState state = world.getBlockState(newPos);
            UseOnContext adjustedContext = new UseOnContext(world, context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation().add((double)(newPos.getX() - pos.getX()), (double)(newPos.getY() - pos.getY()), (double)(newPos.getZ() - pos.getZ())), context.getClickedFace(), newPos, context.isInside()));
            if (!toolAOEData.isValid(world, newPos, state) || modifiedState != state.getToolModifiedState(adjustedContext, action, true)) continue;
            newPos = newPos.immutable();
            energyUsed = nextEnergyUsed;
            if (player != null) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, newPos, context.getItemInHand());
            }
            state.getToolModifiedState(adjustedContext, action, false);
            world.setBlock(newPos, modifiedState, 11);
            world.playSound(null, newPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (particle != -1) {
                world.levelEvent(null, particle, newPos, 0);
            }
            PacketUtils.sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(pos, newPos), toolAOEData.getLightningPos(pos), toolAOEData.getLightningPos(newPos), 10), world, pos);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return InteractionResult.CONSUME;
    }

    @NothingNullByDefault
    public static enum FarmingRadius implements IHasTextComponent,
    StringRepresentable
    {
        OFF(0),
        LOW(1),
        MED(3),
        HIGH(5),
        ULTRA(7);

        public static final Codec<FarmingRadius> CODEC;
        public static final IntFunction<FarmingRadius> BY_ID;
        public static final StreamCodec<ByteBuf, FarmingRadius> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final int radius;
        private final Component label;

        private FarmingRadius(int radius) {
            this.radius = radius;
            this.label = TextComponentUtil.getString(Integer.toString(radius));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public int getRadius() {
            return this.radius;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FarmingRadius::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])FarmingRadius.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private static class HoeToolAOEData
    extends FlatToolAOEData {
        private HoeToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos pos, BlockState state) {
            return true;
        }
    }

    private static interface IToolAOEData {
        public boolean isValid(Level var1, BlockPos var2, BlockState var3);

        default public void persistData(Level level, BlockPos pos, BlockState state, Direction side) {
        }

        public Iterable<BlockPos> getTargetPositions(BlockPos var1, Direction var2, int var3);

        public Vec3 getLightningPos(BlockPos var1);
    }

    private static class ShovelToolAOEData
    extends FlatToolAOEData {
        private ShovelToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos pos, BlockState state) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            if (aboveState.isAir()) {
                return true;
            }
            if (aboveState.is(MekanismTags.Blocks.FARMING_OVERRIDE) || aboveState.canBeReplaced() && aboveState.is(BlockTags.REPLACEABLE_BY_TREES)) {
                return aboveState.getFluidState().isEmpty() && !aboveState.isSolidRender((BlockGetter)level, abovePos);
            }
            return false;
        }
    }

    private static class AxeToolAOEData
    implements IToolAOEData {
        @Nullable
        private Direction.Axis axis;
        private boolean isSet;
        private Vec3 offset = Vec3.ZERO;

        private AxeToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos blockPos, BlockState state) {
            return !this.isSet || this.axis == this.getAxis(state);
        }

        @Override
        public void persistData(Level level, BlockPos pos, BlockState state, Direction side) {
            this.axis = this.getAxis(state);
            this.isSet = true;
            this.offset = Vec3.atLowerCornerOf((Vec3i)side.getNormal()).scale(0.5);
        }

        @Override
        public Iterable<BlockPos> getTargetPositions(BlockPos pos, Direction side, int radius) {
            Vec3i adjustment = switch (side) {
                default -> throw new MatchException(null, null);
                case Direction.EAST, Direction.WEST -> new Vec3i(0, radius, radius);
                case Direction.UP, Direction.DOWN -> new Vec3i(radius, 0, radius);
                case Direction.SOUTH, Direction.NORTH -> new Vec3i(radius, radius, 0);
            };
            BlockPos first = pos.subtract(adjustment);
            BlockPos second = pos.offset(adjustment);
            AABB box = new AABB((double)first.getX(), (double)first.getY(), (double)first.getZ(), (double)second.getX(), (double)second.getY(), (double)second.getZ());
            return BlockPos.betweenClosed((BlockPos)BlockPos.containing((double)box.minX, (double)box.minY, (double)box.minZ), (BlockPos)BlockPos.containing((double)box.maxX, (double)box.maxY, (double)box.maxZ));
        }

        @Nullable
        private Direction.Axis getAxis(BlockState state) {
            return state.hasProperty((Property)RotatedPillarBlock.AXIS) ? (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS) : null;
        }

        @Override
        public Vec3 getLightningPos(BlockPos pos) {
            return pos.getCenter().add(this.offset);
        }
    }

    private static abstract class FlatToolAOEData
    implements IToolAOEData {
        private FlatToolAOEData() {
        }

        @Override
        public Iterable<BlockPos> getTargetPositions(BlockPos pos, Direction side, int radius) {
            return BlockPos.betweenClosed((BlockPos)pos.offset(-radius, 0, -radius), (BlockPos)pos.offset(radius, 0, radius));
        }

        @Override
        public Vec3 getLightningPos(BlockPos pos) {
            return Vec3.upFromBottomCenterOf((Vec3i)pos, (double)0.94);
        }
    }
}

