/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.function.Consumer;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.listener.ConfigBasedCachedFLSupplier;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

@ParametersAreNotNullByDefault
public record ModuleGravitationalModulatingUnit(ModuleLocomotiveBoostingUnit.SprintBoost speedBoost) implements ICustomModule<ModuleGravitationalModulatingUnit>
{
    private static final AttributeModifier CREATIVE_FLIGHT_MODIFIER = new AttributeModifier(Mekanism.rl("mekasuit_gravitational_modulation"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private static final ConfigBasedCachedFLSupplier BOOST_USAGE = new ConfigBasedCachedFLSupplier(() -> ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get()).multiply(4L), (CachedValue<?>[])new CachedValue[]{MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation});
    private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "gravitational_modulation_unit.png");
    private static final Vec3 BOOST_VEC = new Vec3(0.0, 0.0, 1.0);
    public static final ResourceLocation SPEED_BOOST = Mekanism.rl("speed_boost");

    public ModuleGravitationalModulatingUnit(IModule<ModuleGravitationalModulatingUnit> module) {
        this((ModuleLocomotiveBoostingUnit.SprintBoost)module.getConfigOrThrow(SPEED_BOOST).get());
    }

    @Override
    public void addHUDElements(IModule<ModuleGravitationalModulatingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player, Consumer<IHUDElement> hudElementAdder) {
        hudElementAdder.accept(IModuleHelper.INSTANCE.hudElementEnabled(icon, module.isEnabled()));
    }

    @Override
    public boolean canChangeModeWhenDisabled(IModule<ModuleGravitationalModulatingUnit> module) {
        return true;
    }

    @Override
    public void changeMode(IModule<ModuleGravitationalModulatingUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, int shift, boolean displayChangeMessage) {
        module.toggleEnabled(moduleContainer, stack, player, (Component)MekanismLang.MODULE_GRAVITATIONAL_MODULATION.translate());
    }

    @Override
    public void adjustAttributes(IModule<ModuleGravitationalModulatingUnit> module, ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(MekanismItems.MEKASUIT_BODYARMOR) && module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation)) {
            event.addModifier(NeoForgeMod.CREATIVE_FLIGHT, CREATIVE_FLIGHT_MODIFIER, EquipmentSlotGroup.CHEST);
        }
    }

    @Override
    public void tickClient(IModule<ModuleGravitationalModulatingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        float boost;
        if (ModuleGravitationalModulatingUnit.shouldProcess(player) && MekanismKeyHandler.boostKey.isDown() && module.hasEnoughEnergy(stack, BOOST_USAGE) && (boost = this.speedBoost.getBoost()) > 0.0f) {
            player.moveRelative(boost, BOOST_VEC);
        }
    }

    @Override
    public void tickServer(IModule<ModuleGravitationalModulatingUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        if (ModuleGravitationalModulatingUnit.shouldProcess(player) && module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation)) {
            float boost = this.speedBoost.getBoost();
            if (boost > 0.0f && Mekanism.keyMap.has(player.getUUID(), 1) && module.hasEnoughEnergy(stack, BOOST_USAGE)) {
                player.moveRelative(boost, BOOST_VEC);
                module.useEnergy((LivingEntity)player, stack, (FloatingLong)BOOST_USAGE.get());
                ModuleGravitationalModulatingUnit.gravUnitGameEvent(player, MekanismGameEvents.GRAVITY_MODULATE_BOOSTED);
            } else {
                module.useEnergy((LivingEntity)player, stack, (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get());
                ModuleGravitationalModulatingUnit.gravUnitGameEvent(player, MekanismGameEvents.GRAVITY_MODULATE);
            }
        }
    }

    private static void gravUnitGameEvent(Player player, Holder<GameEvent> gameEvent) {
        if (MekanismConfig.gear.mekaSuitGravitationalVibrations.get() && player.level().getGameTime() % 10L == 0L) {
            player.gameEvent(gameEvent);
        }
    }

    public static boolean shouldProcess(Player player) {
        return player.getAbilities().flying && MekanismUtils.isPlayingMode(player);
    }
}

