/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public final class Module<MODULE extends ICustomModule<MODULE>>
implements IModule<MODULE> {
    public static final Codec<Module<?>> CODEC = InstalledData.CODEC.dispatch(module -> new InstalledData(module.getData(), module.getInstalledCount()), installedData -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)installedData.configCodecs().forGetter(Module::getConfigs)).apply((Applicative)instance, installedData::create)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Module<?>> STREAM_CODEC = InstalledData.STREAM_CODEC.dispatch(module -> new InstalledData(module.getData(), module.getInstalledCount()), installedData -> installedData.configStreamCodecs().map(installedData::create, Module::getConfigs));
    private final Map<ResourceLocation, ModuleConfig<?>> configItemsByName = new HashMap();
    private final List<ModuleConfig<?>> configItems;
    private final ModuleData<MODULE> data;
    private final MODULE customModule;
    private final boolean enabled;
    private final boolean handleModeChange;
    private final boolean renderHUD;
    private final int installed;

    Module(ModuleData<MODULE> data, int installed) {
        this(data, installed, data.defaultConfigs(installed));
    }

    Module(ModuleData<MODULE> data, int installed, List<ModuleConfig<?>> configItems) {
        this.data = data;
        this.installed = installed;
        this.configItems = configItems;
        for (ModuleConfig<?> configItem : this.configItems) {
            this.configItemsByName.put(configItem.name(), configItem);
        }
        this.enabled = this.getBooleanConfigOrFalse(ModuleConfig.ENABLED_KEY);
        this.handleModeChange = this.getBooleanConfigOrFalse(ModuleConfig.HANDLES_MODE_CHANGE_KEY);
        this.renderHUD = this.getBooleanConfigOrFalse(ModuleConfig.RENDER_HUD_KEY);
        this.customModule = data.create(this);
    }

    @Override
    public MODULE getCustomInstance() {
        return this.customModule;
    }

    public void tick(IModuleContainer moduleContainer, ItemStack stack, Player player) {
        if (this.isEnabled()) {
            if (player.level().isClientSide()) {
                this.customModule.tickClient(this, moduleContainer, stack, player);
            } else {
                this.customModule.tickServer(this, moduleContainer, stack, player);
            }
        }
    }

    @Override
    @Nullable
    public IEnergyContainer getEnergyContainer(ItemStack stack) {
        return StorageUtils.getEnergyContainer(stack, 0);
    }

    @Override
    public FloatingLong getContainerEnergy(ItemStack stack) {
        IEnergyContainer energyContainer = this.getEnergyContainer(stack);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
    }

    @Override
    public boolean hasEnoughEnergy(ItemStack stack, FloatingLongSupplier energySupplier) {
        return this.hasEnoughEnergy(stack, energySupplier.get());
    }

    @Override
    public boolean hasEnoughEnergy(ItemStack stack, FloatingLong cost) {
        return cost.isZero() || this.getContainerEnergy(stack).greaterOrEqual(cost);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, ItemStack stack, FloatingLong energy) {
        return this.canUseEnergy(wearer, stack, energy, false);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, ItemStack stack, FloatingLong energy, boolean ignoreCreative) {
        return this.canUseEnergy(wearer, this.getEnergyContainer(stack), energy, ignoreCreative);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean ignoreCreative) {
        Player player;
        if (!(energyContainer == null || wearer.isSpectator() || ignoreCreative && wearer instanceof Player && (player = (Player)wearer).isCreative())) {
            return energyContainer.extract(energy, Action.SIMULATE, AutomationType.MANUAL).equals(energy);
        }
        return false;
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, ItemStack stack, FloatingLong energy) {
        return this.useEnergy(wearer, stack, energy, true);
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, ItemStack stack, FloatingLong energy, boolean freeCreative) {
        return this.useEnergy(wearer, this.getEnergyContainer(stack), energy, freeCreative);
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean freeCreative) {
        Player player;
        if (!(energyContainer == null || freeCreative && wearer instanceof Player && !MekanismUtils.isPlayingMode(player = (Player)wearer))) {
            return energyContainer.extract(energy, Action.EXECUTE, AutomationType.MANUAL);
        }
        return FloatingLong.ZERO;
    }

    @Override
    public ModuleData<MODULE> getData() {
        return this.data;
    }

    @Override
    @Nullable
    public <TYPE> ModuleConfig<TYPE> getConfig(ResourceLocation name) {
        return this.configItemsByName.get(name);
    }

    public List<ModuleConfig<?>> getConfigs() {
        return this.configItems;
    }

    @Override
    public int getInstalledCount() {
        return this.installed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    Module<MODULE> withReplacedInstallCount(int installed) {
        List<ModuleConfig<?>> moduleConfigs = this.data.defaultConfigs(installed);
        ArrayList copiedConfigs = new ArrayList(moduleConfigs.size());
        for (ModuleConfig<?> moduleConfig : moduleConfigs) {
            ResourceLocation name = moduleConfig.name();
            ModuleConfig<?> existingConfig = this.configItemsByName.get(name);
            if (existingConfig == null) {
                copiedConfigs.add(moduleConfig);
                continue;
            }
            if (moduleConfig.getClass() == existingConfig.getClass()) {
                copiedConfigs.add(this.configWithValue(moduleConfig, existingConfig));
                continue;
            }
            throw new IllegalStateException("Expected module config " + String.valueOf(name) + " to have the same class regardless of installed count.");
        }
        return new Module<MODULE>(this.data, installed, List.copyOf(copiedConfigs));
    }

    private <CONFIG> ModuleConfig<CONFIG> configWithValue(ModuleConfig<CONFIG> defaultConfig, ModuleConfig<?> existing) {
        try {
            return defaultConfig.with(existing.get());
        }
        catch (IllegalArgumentException e) {
            return defaultConfig;
        }
    }

    Module<MODULE> withReplacedConfig(ModuleConfig<?> config) {
        return this.withReplacedConfig(config, false);
    }

    <CONFIG> Module<MODULE> withReplacedConfig(ModuleConfig<CONFIG> config, boolean fromPacket) {
        for (int i = 0; i < this.configItems.size(); ++i) {
            ModuleConfig<?> storedConfig = this.configItems.get(i);
            if (!storedConfig.name().equals((Object)config.name())) continue;
            if (storedConfig.get().equals(config.get())) {
                return this;
            }
            if (fromPacket) {
                if (storedConfig.getClass() != config.getClass()) {
                    throw new IllegalStateException("Config " + String.valueOf(config.name()) + "'s Class " + config.getClass().getSimpleName() + "  did not match " + storedConfig.getClass().getSimpleName());
                }
                config = storedConfig.with(config.get());
            }
            ArrayList copiedConfigs = new ArrayList(this.configItems);
            copiedConfigs.set(i, config);
            return new Module<MODULE>(this.data, this.installed, List.copyOf(copiedConfigs));
        }
        throw new IllegalStateException("Could not find an existing config with name: " + String.valueOf(config.name()));
    }

    public void addHUDStrings(Player player, IModuleContainer moduleContainer, ItemStack stack, List<Component> list) {
        if (this.renderHUD) {
            this.customModule.addHUDStrings(this, moduleContainer, stack, player, list::add);
        }
    }

    public void addHUDElements(Player player, IModuleContainer moduleContainer, ItemStack stack, List<IHUDElement> list) {
        if (this.renderHUD) {
            this.customModule.addHUDElements(this, moduleContainer, stack, player, list::add);
        }
    }

    boolean handlesModeChangeRaw() {
        return this.handleModeChange;
    }

    @Override
    public boolean handlesModeChange() {
        return this.handleModeChange && (this.isEnabled() || this.customModule.canChangeModeWhenDisabled(this));
    }

    @Override
    public boolean handlesRadialModeChange() {
        if (this.getConfig(ModuleConfig.HANDLES_MODE_CHANGE_KEY) == null) {
            return false;
        }
        return this.isEnabled() || this.customModule.canChangeRadialModeWhenDisabled(this);
    }

    @Override
    public boolean handlesAnyModeChange() {
        if (this.getConfig(ModuleConfig.HANDLES_MODE_CHANGE_KEY) == null) {
            return false;
        }
        return this.isEnabled() || this.handleModeChange && this.customModule.canChangeModeWhenDisabled(this) || this.customModule.canChangeRadialModeWhenDisabled(this);
    }

    @Override
    public void displayModeChange(Player player, Component modeName, IHasTextComponent mode) {
        Component modeComponent = mode.getTextComponent();
        if (modeComponent.getStyle().getColor() != null) {
            player.sendSystemMessage(MekanismUtils.logFormat(MekanismLang.MODULE_MODE_CHANGE.translate(modeName, modeComponent)));
        } else {
            player.sendSystemMessage(MekanismUtils.logFormat(MekanismLang.MODULE_MODE_CHANGE.translate(modeName, EnumColor.INDIGO, modeComponent)));
        }
    }

    @Override
    public void toggleEnabled(IModuleContainer moduleContainer, ItemStack stack, Player player, Component modeName) {
        MutableComponent message = this.enabled ? MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.DARK_RED, MekanismLang.MODULE_DISABLED_LOWER) : MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.BRIGHT_GREEN, MekanismLang.MODULE_ENABLED_LOWER);
        player.sendSystemMessage(MekanismUtils.logFormat(message));
        ((ModuleContainer)moduleContainer).toggleEnabled((HolderLookup.Provider)player.level().registryAccess(), stack, this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return this.installed == module.installed && Objects.equals(this.configItems, module.configItems) && Objects.equals(this.data, module.data);
    }

    public int hashCode() {
        return Objects.hash(this.configItems, this.data, this.installed);
    }

    private record InstalledData<MODULE extends ICustomModule<MODULE>>(ModuleData<MODULE> data, int installed) {
        private static final Codec<InstalledData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MekanismAPI.MODULE_REGISTRY.byNameCodec().fieldOf("type").forGetter(InstalledData::data), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(InstalledData::installed)).apply((Applicative)instance, InstalledData::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, InstalledData<?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(MekanismAPI.MODULE_REGISTRY_NAME), InstalledData::data, (StreamCodec)ByteBufCodecs.VAR_INT, InstalledData::installed, InstalledData::new);

        public Module<MODULE> create(List<ModuleConfig<?>> configs) {
            return new Module<MODULE>(this.data, this.installed, configs);
        }

        public MapCodec<List<ModuleConfig<?>>> configCodecs() {
            return this.data.configCodecs(this.installed).optionalFieldOf("config", this.data.defaultConfigs(this.installed));
        }

        public StreamCodec<RegistryFriendlyByteBuf, List<ModuleConfig<?>>> configStreamCodecs() {
            return this.data.configStreamCodecs(this.installed);
        }
    }
}

