/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.heat.HeatAPI;
import mekanism.api.math.MathUtils;
import mekanism.common.block.attribute.AttributeStateBoilerValveMode;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityBoilerValve;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.fluids.FluidStack;

public class BoilerMultiblockData
extends MultiblockData
implements IValveHandler {
    public static final Object2BooleanMap<UUID> hotMap = new Object2BooleanOpenHashMap();
    public static final double CASING_HEAT_CAPACITY = 50.0;
    private static final double CASING_INVERSE_INSULATION_COEFFICIENT = 100000.0;
    private static final double CASING_INVERSE_CONDUCTION_COEFFICIENT = 1.0;
    private static final double COOLANT_COOLING_EFFICIENCY = 0.4;
    private final List<MultiblockData.AdvancedCapabilityOutputTarget<IGasHandler, AttributeStateBoilerValveMode.BoilerValveMode>> gasOutputTargets = new ArrayList<MultiblockData.AdvancedCapabilityOutputTarget<IGasHandler, AttributeStateBoilerValveMode.BoilerValveMode>>();
    private final List<IGasTank> inputTanks;
    private final List<IGasTank> outputSteamTanks;
    private final List<IGasTank> outputCoolantTanks;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getHeatedCoolant", "getHeatedCoolantCapacity", "getHeatedCoolantNeeded", "getHeatedCoolantFilledPercentage"}, docPlaceholder="heated coolant tank")
    public IGasTank superheatedCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getCooledCoolant", "getCooledCoolantCapacity", "getCooledCoolantNeeded", "getCooledCoolantFilledPercentage"}, docPlaceholder="cooled coolant tank")
    public IGasTank cooledCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getWater", "getWaterCapacity", "getWaterNeeded", "getWaterFilledPercentage"}, docPlaceholder="water tank")
    public VariableCapacityFluidTank waterTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"}, docPlaceholder="steam tank")
    public IGasTank steamTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="boiler")
    public VariableHeatCapacitor heatCapacitor;
    private double biomeAmbientTemp;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss", getterDescription="Get the amount of heat lost to the environment in the last tick (Kelvin)")
    public double lastEnvironmentLoss;
    @ContainerSync
    @SyntheticComputerMethod(getter="getBoilRate", getterDescription="Get the rate of boiling (mB/t)")
    public int lastBoilRate;
    @ContainerSync
    @SyntheticComputerMethod(getter="getMaxBoilRate", getterDescription="Get the maximum rate of boiling seen (mB/t)")
    public int lastMaxBoil;
    @ContainerSync
    @SyntheticComputerMethod(getter="getSuperheaters", getterDescription="How many superheaters this Boiler has")
    public int superheatingElements;
    @ContainerSync(setter="setWaterVolume")
    private int waterVolume;
    @ContainerSync(setter="setSteamVolume")
    private int steamVolume;
    private int waterTankCapacity;
    private long superheatedCoolantCapacity;
    private long steamTankCapacity;
    private long cooledCoolantCapacity;
    public BlockPos upperRenderLocation;
    public float prevWaterScale;
    public float prevSteamScale;

    public BoilerMultiblockData(TileEntityBoilerCasing tile) {
        super(tile);
        this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.getLevel(), tile.getBlockPos());
        this.superheatedCoolantTank = MultiblockChemicalTankBuilder.GAS.input(this, () -> this.superheatedCoolantCapacity, gas -> gas.has(GasAttributes.HeatedCoolant.class), this);
        this.waterTank = VariableCapacityFluidTank.input(this, () -> this.waterTankCapacity, fluid -> fluid.is(FluidTags.WATER), this.createSaveAndComparator());
        this.fluidTanks.add(this.waterTank);
        this.steamTank = MultiblockChemicalTankBuilder.GAS.output(this, () -> this.steamTankCapacity, gas -> gas == MekanismGases.STEAM.getChemical(), this);
        this.cooledCoolantTank = MultiblockChemicalTankBuilder.GAS.output(this, () -> this.cooledCoolantCapacity, gas -> gas.has(GasAttributes.CooledCoolant.class), this);
        this.inputTanks = List.of(this.superheatedCoolantTank);
        this.outputSteamTanks = List.of(this.steamTank);
        this.outputCoolantTanks = List.of(this.cooledCoolantTank);
        Collections.addAll(this.gasTanks, this.steamTank, this.superheatedCoolantTank, this.cooledCoolantTank);
        this.heatCapacitor = VariableHeatCapacitor.create(50.0, () -> 1.0, () -> 100000.0, () -> this.biomeAmbientTemp, (IContentsListener)this);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    @Override
    public void onCreated(Level world) {
        super.onCreated(world);
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.heatCapacitor.setHeatCapacity(50.0 * (double)this.locations.size(), true);
    }

    @Override
    public void remove(Level world, Structure oldStructure) {
        hotMap.removeBoolean((Object)this.inventoryID);
        super.remove(world, oldStructure);
    }

    @Override
    public boolean tick(Level world) {
        float steamScale;
        float waterScale;
        GasAttributes.HeatedCoolant coolantType;
        boolean needsPacket = super.tick(world);
        hotMap.put((Object)this.inventoryID, this.getTotalTemperature() >= HeatUtils.BASE_BOIL_TEMP - 0.01);
        this.lastEnvironmentLoss = this.simulateEnvironment();
        this.updateHeatCapacitors(null);
        if (!this.superheatedCoolantTank.isEmpty() && (coolantType = ((GasStack)this.superheatedCoolantTank.getStack()).get(GasAttributes.HeatedCoolant.class)) != null) {
            long toCool = Math.round(0.4 * (double)this.superheatedCoolantTank.getStored());
            toCool = MathUtils.clampToLong((double)toCool * (1.0 - this.heatCapacitor.getTemperature() / 100000.0));
            GasStack cooledCoolant = coolantType.getCooledGas().getStack(toCool);
            if ((toCool = Math.min(toCool, toCool - this.cooledCoolantTank.insert(cooledCoolant, Action.EXECUTE, AutomationType.INTERNAL).getAmount())) > 0L) {
                double heatEnergy = (double)toCool * coolantType.getThermalEnthalpy();
                this.heatCapacitor.handleHeat(heatEnergy);
                this.superheatedCoolantTank.shrinkStack(toCool, Action.EXECUTE);
            }
        }
        if (this.getTotalTemperature() >= HeatUtils.BASE_BOIL_TEMP && !this.waterTank.isEmpty()) {
            double heatAvailable = this.getHeatAvailable();
            this.lastMaxBoil = Mth.floor((double)(HeatUtils.getSteamEnergyEfficiency() * heatAvailable / HeatUtils.getWaterThermalEnthalpy()));
            int amountToBoil = Math.min(this.lastMaxBoil, this.waterTank.getFluidAmount());
            amountToBoil = Math.min(amountToBoil, MathUtils.clampToInt(this.steamTank.getNeeded()));
            if (!this.waterTank.isEmpty()) {
                this.waterTank.shrinkStack(amountToBoil, Action.EXECUTE);
            }
            if (this.steamTank.isEmpty()) {
                this.steamTank.setStack(MekanismGases.STEAM.getStack(amountToBoil));
            } else {
                this.steamTank.growStack(amountToBoil, Action.EXECUTE);
            }
            this.heatCapacitor.handleHeat((double)(-amountToBoil) * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency());
            this.lastBoilRate = amountToBoil;
        } else {
            this.lastBoilRate = 0;
            this.lastMaxBoil = 0;
        }
        if (!this.gasOutputTargets.isEmpty()) {
            if (!this.steamTank.isEmpty()) {
                ChemicalUtil.emit(this.getActiveOutputs(this.gasOutputTargets, AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_STEAM), this.steamTank);
            }
            if (!this.cooledCoolantTank.isEmpty()) {
                ChemicalUtil.emit(this.getActiveOutputs(this.gasOutputTargets, AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_COOLANT), this.cooledCoolantTank);
            }
        }
        if (MekanismUtils.scaleChanged(waterScale = MekanismUtils.getScale(this.prevWaterScale, this.waterTank), this.prevWaterScale)) {
            needsPacket = true;
            this.prevWaterScale = waterScale;
        }
        if (MekanismUtils.scaleChanged(steamScale = MekanismUtils.getScale(this.prevSteamScale, this.steamTank), this.prevSteamScale)) {
            needsPacket = true;
            this.prevSteamScale = steamScale;
        }
        return needsPacket;
    }

    @Override
    protected void updateEjectors(Level world) {
        this.gasOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityBoilerValve tile = WorldUtils.getTileEntity(TileEntityBoilerValve.class, (BlockGetter)world, valve.location);
            if (tile == null) continue;
            tile.addGasTargetCapability(this.gasOutputTargets, valve.side);
        }
    }

    public List<IGasTank> getGasTanks(AttributeStateBoilerValveMode.BoilerValveMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case AttributeStateBoilerValveMode.BoilerValveMode.INPUT -> this.inputTanks;
            case AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_STEAM -> this.outputSteamTanks;
            case AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_COOLANT -> this.outputCoolantTanks;
        };
    }

    @Override
    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.readUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevWaterScale = scale;
        });
        NBTUtils.setFloatIfPresent(tag, "scale_alt", scale -> {
            this.prevSteamScale = scale;
        });
        NBTUtils.setIntIfPresent(tag, "volume", this::setWaterVolume);
        NBTUtils.setIntIfPresent(tag, "lower_volume", this::setSteamVolume);
        NBTUtils.setFluidStackIfPresent(provider, tag, "fluid", value -> this.waterTank.setStack((FluidStack)value));
        NBTUtils.setGasStackIfPresent(provider, tag, "gas", value -> this.steamTank.setStack(value));
        NBTUtils.setBlockPosIfPresent(tag, "render_y", value -> {
            this.upperRenderLocation = value;
        });
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeUpdateTag(tag, provider);
        tag.putFloat("scale", this.prevWaterScale);
        tag.putFloat("scale_alt", this.prevSteamScale);
        tag.putInt("volume", this.getWaterVolume());
        tag.putInt("lower_volume", this.getSteamVolume());
        tag.put("fluid", this.waterTank.getFluid().saveOptional(provider));
        tag.put("gas", ((GasStack)this.steamTank.getStack()).saveOptional(provider));
        tag.put("render_y", NbtUtils.writeBlockPos((BlockPos)this.upperRenderLocation));
        this.writeValves(tag);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.waterTank.getFluidAmount(), this.waterTank.getCapacity());
    }

    private double getHeatAvailable() {
        double heatAvailable = (this.heatCapacitor.getTemperature() - HeatUtils.BASE_BOIL_TEMP) * (this.heatCapacitor.getHeatCapacity() * MekanismConfig.general.boilerWaterConductivity.get());
        return Math.min(heatAvailable, MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superheatingElements);
    }

    @Override
    public double simulateEnvironment() {
        double invConduction = 110001.0;
        double tempToTransfer = (this.heatCapacitor.getTemperature() - this.biomeAmbientTemp) / invConduction;
        this.heatCapacitor.handleHeat(-tempToTransfer * this.heatCapacitor.getHeatCapacity());
        return Math.max(tempToTransfer, 0.0);
    }

    public int getWaterVolume() {
        return this.waterVolume;
    }

    public void setWaterVolume(int volume) {
        if (this.waterVolume != volume) {
            this.waterVolume = volume;
            this.waterTankCapacity = volume * MekanismConfig.general.boilerWaterPerTank.get();
            this.superheatedCoolantCapacity = (long)volume * MekanismConfig.general.boilerHeatedCoolantPerTank.get();
        }
    }

    public int getSteamVolume() {
        return this.steamVolume;
    }

    public void setSteamVolume(int volume) {
        if (this.steamVolume != volume) {
            this.steamVolume = volume;
            this.steamTankCapacity = (long)volume * MekanismConfig.general.boilerSteamPerTank.get();
            this.cooledCoolantCapacity = (long)volume * MekanismConfig.general.boilerCooledCoolantPerTank.get();
        }
    }

    @ComputerMethod(methodDescription="Get the maximum possible boil rate for this Boiler, based on the number of Superheating Elements")
    public long getBoilCapacity() {
        double boilCapacity = MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superheatingElements / HeatUtils.getWaterThermalEnthalpy();
        return MathUtils.clampToLong(boilCapacity * HeatUtils.getSteamEnergyEfficiency());
    }
}

