/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedResolvableConfigValue;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class CachedResourceLocationListValue
extends CachedResolvableConfigValue<List<ResourceLocation>, List<? extends String>> {
    private static final Supplier<List<? extends String>> EMPTY = ArrayList::new;

    private CachedResourceLocationListValue(IMekanismConfig config, ModConfigSpec.ConfigValue<List<? extends String>> internal) {
        super(config, internal);
    }

    public static CachedResourceLocationListValue define(IMekanismConfig config, ModConfigSpec.Builder builder, String path, Predicate<@NotNull ResourceLocation> rlValidator) {
        return new CachedResourceLocationListValue(config, (ModConfigSpec.ConfigValue<List<? extends String>>)builder.defineListAllowEmpty(Collections.singletonList(path), EMPTY, o -> {
            String string;
            ResourceLocation rl;
            if (o instanceof String && (rl = ResourceLocation.tryParse((String)(string = (String)o).toLowerCase(Locale.ROOT))) != null) {
                return rlValidator.test(rl);
            }
            return false;
        }));
    }

    @Override
    protected List<ResourceLocation> resolve(List<? extends String> encoded) {
        return encoded.stream().map(s -> ResourceLocation.tryParse((String)s.toLowerCase(Locale.ROOT))).filter(Objects::nonNull).toList();
    }

    @Override
    protected List<? extends String> encode(List<ResourceLocation> values) {
        return values.stream().map(ResourceLocation::toString).toList();
    }
}

