/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MekanismStartupConfig
extends BaseMekanismConfig {
    private static final String ARMORED_SUBCATEGORY = "armored";
    private final ModConfigSpec configSpec;
    public final CachedIntValue armoredFreeRunnerArmor;
    public final CachedFloatValue armoredFreeRunnerToughness;
    public final CachedFloatValue armoredFreeRunnerKnockbackResistance;
    public final CachedIntValue armoredJetpackArmor;
    public final CachedFloatValue armoredJetpackToughness;
    public final CachedFloatValue armoredJetpackKnockbackResistance;
    public final CachedIntValue mekaSuitHelmetArmor;
    public final CachedIntValue mekaSuitBodyArmorArmor;
    public final CachedIntValue mekaSuitPantsArmor;
    public final CachedIntValue mekaSuitBootsArmor;
    public final CachedFloatValue mekaSuitToughness;
    public final CachedFloatValue mekaSuitKnockbackResistance;

    MekanismStartupConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Mekanism Startup Config. This config is loaded on early, and requires a game restart to take effect, and is not synced automatically between client and server. It is highly recommended to ensure you are using the same values for this config on the server and client.").push("startup");
        builder.comment("Startup gear configs").push("gear");
        builder.comment("Free Runner Settings").push("free_runner");
        builder.comment("Armored Free Runner Settings").push(ARMORED_SUBCATEGORY);
        this.armoredFreeRunnerArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Armor value of the Armored Free Runners").defineInRange("armor", 3, 0, Integer.MAX_VALUE));
        this.armoredFreeRunnerToughness = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)builder.comment("Toughness value of the Armored Free Runners.").defineInRange("toughness", 2.0, 0.0, 3.4028234663852886E38));
        this.armoredFreeRunnerKnockbackResistance = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)builder.comment("Knockback resistance value of the Armored Free Runners.").defineInRange("knockbackResistance", 0.0, 0.0, 3.4028234663852886E38));
        builder.pop(2);
        builder.comment("Jetpack Settings").push("jetpack");
        builder.comment("Armored Jetpack Settings").push(ARMORED_SUBCATEGORY);
        this.armoredJetpackArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Armor value of the Armored Jetpack.").defineInRange("armor", 8, 0, Integer.MAX_VALUE));
        this.armoredJetpackToughness = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)builder.comment("Toughness value of the Armored Jetpack.").defineInRange("toughness", 2.0, 0.0, 3.4028234663852886E38));
        this.armoredJetpackKnockbackResistance = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)builder.comment("Knockback resistance value of the Armored Jetpack.").defineInRange("knockbackResistance", 0.0, 0.0, 3.4028234663852886E38));
        builder.pop(2);
        builder.comment("MekaSuit Settings").push("mekasuit");
        this.mekaSuitHelmetArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Armor value of MekaSuit Helmets.").defineInRange("helmetArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.HELMET)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitBodyArmorArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Armor value of MekaSuit BodyArmor.").defineInRange("bodyArmorArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.CHESTPLATE)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitPantsArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Armor value of MekaSuit Pants.").defineInRange("pantsArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.LEGGINGS)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitBootsArmor = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Armor value of MekaSuit Boots.").defineInRange("bootsArmor", ((Integer)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).defense().get(ArmorItem.Type.BOOTS)).intValue(), 0, Integer.MAX_VALUE));
        this.mekaSuitToughness = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)builder.comment("Toughness value of the MekaSuit.").defineInRange("toughness", (double)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).toughness(), 0.0, 3.4028234663852886E38));
        this.mekaSuitKnockbackResistance = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)builder.comment("Knockback resistance value of the MekaSuit.").defineInRange("knockbackResistance", (double)((ArmorMaterial)ArmorMaterials.NETHERITE.value()).knockbackResistance(), 0.0, 3.4028234663852886E38));
        builder.pop();
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "startup";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.STARTUP;
    }
}

