/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.merged;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public class MergedTank
extends MergedChemicalTank {
    private final IExtendedFluidTank fluidTank;

    public static MergedTank create(IExtendedFluidTank fluidTank, IGasTank gasTank, IInfusionTank infusionTank, IPigmentTank pigmentTank, ISlurryTank slurryTank) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(infusionTank, "Infusion tank cannot be null");
        Objects.requireNonNull(pigmentTank, "Pigment tank cannot be null");
        Objects.requireNonNull(slurryTank, "Slurry tank cannot be null");
        return new MergedTank(fluidTank, gasTank, infusionTank, pigmentTank, slurryTank);
    }

    private MergedTank(IExtendedFluidTank fluidTank, IChemicalTank<?, ?> ... chemicalTanks) {
        super(fluidTank::isEmpty, chemicalTanks);
        this.fluidTank = new FluidTankWrapper(this, fluidTank, chemicalTanks);
    }

    public CurrentType getCurrentType() {
        if (!this.getFluidTank().isEmpty()) {
            return CurrentType.FLUID;
        }
        return switch (this.getCurrent()) {
            default -> throw new MatchException(null, null);
            case MergedChemicalTank.Current.EMPTY -> CurrentType.EMPTY;
            case MergedChemicalTank.Current.GAS -> CurrentType.GAS;
            case MergedChemicalTank.Current.INFUSION -> CurrentType.INFUSION;
            case MergedChemicalTank.Current.PIGMENT -> CurrentType.PIGMENT;
            case MergedChemicalTank.Current.SLURRY -> CurrentType.SLURRY;
        };
    }

    public final IExtendedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void addToUpdateTag(HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag.put("fluid", this.getFluidTank().getFluid().saveOptional(provider));
        updateTag.put("gas", ((GasStack)this.getGasTank().getStack()).saveOptional(provider));
        updateTag.put("infuse_type", ((InfusionStack)this.getInfusionTank().getStack()).saveOptional(provider));
        updateTag.put("pigment", ((PigmentStack)this.getPigmentTank().getStack()).saveOptional(provider));
        updateTag.put("slurry", ((SlurryStack)this.getSlurryTank().getStack()).saveOptional(provider));
    }

    public void readFromUpdateTag(HolderLookup.Provider provider, CompoundTag tag) {
        NBTUtils.setFluidStackIfPresent(provider, tag, "fluid", value -> this.getFluidTank().setStack((FluidStack)value));
        NBTUtils.setGasStackIfPresent(provider, tag, "gas", value -> this.getGasTank().setStack(value));
        NBTUtils.setInfusionStackIfPresent(provider, tag, "infuse_type", value -> this.getInfusionTank().setStack(value));
        NBTUtils.setPigmentStackIfPresent(provider, tag, "pigment", value -> this.getPigmentTank().setStack(value));
        NBTUtils.setSlurryStackIfPresent(provider, tag, "slurry", value -> this.getSlurryTank().setStack(value));
    }

    public static enum CurrentType {
        EMPTY,
        FLUID,
        GAS,
        INFUSION,
        PIGMENT,
        SLURRY;

    }
}

