/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid;

import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidTankFluidTank
extends BasicFluidTank {
    private final TileEntityFluidTank tile;
    private final boolean isCreative;
    private final IntSupplier rate;

    public static FluidTankFluidTank create(TileEntityFluidTank tile, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tile, "Fluid tank tile entity cannot be null");
        return new FluidTankFluidTank(tile, listener);
    }

    private FluidTankFluidTank(TileEntityFluidTank tile, @Nullable IContentsListener listener) {
        super(tile.tier.getStorage(), alwaysTrueBi, alwaysTrueBi, (Predicate<FluidStack>)alwaysTrue, listener);
        this.tile = tile;
        this.rate = tile.tier::getOutput;
        this.isCreative = tile.tier == FluidTankTier.CREATIVE;
    }

    @Override
    protected int getInsertRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsInt() : super.getInsertRate(automationType);
    }

    @Override
    protected int getExtractRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsInt() : super.getExtractRate(automationType);
    }

    @Override
    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        TileEntityFluidTank tileAbove;
        FluidStack remainder;
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            remainder = super.insert(stack, Action.SIMULATE, automationType);
            if (remainder.isEmpty()) {
                this.setStackUnchecked(stack.copyWithAmount(this.getCapacity()));
            }
        } else {
            remainder = super.insert(stack, action.combine(!this.isCreative), automationType);
        }
        if (!remainder.isEmpty() && (tileAbove = WorldUtils.getTileEntity(TileEntityFluidTank.class, (BlockGetter)this.tile.getLevel(), this.tile.getBlockPos().above())) != null) {
            remainder = tileAbove.fluidTank.insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    @Override
    public int growStack(int amount, Action action) {
        TileEntityFluidTank tileAbove;
        int grownAmount = super.growStack(amount, action);
        if (amount > 0 && grownAmount < amount && !this.tile.getActive() && (tileAbove = WorldUtils.getTileEntity(TileEntityFluidTank.class, (BlockGetter)this.tile.getLevel(), this.tile.getBlockPos().above())) != null) {
            int leftOverToInsert = amount - grownAmount;
            FluidStack remainder = tileAbove.fluidTank.insert(this.stored.copyWithAmount(leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }

    @Override
    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

