/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical.item;

import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.chemical.ChemicalTanksBuilder;
import mekanism.common.attachments.containers.chemical.ComponentBackedChemicalTank;
import mekanism.common.capabilities.GenericTankSpec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalTankSpec<CHEMICAL extends Chemical<CHEMICAL>>
extends GenericTankSpec<CHEMICAL> {
    private static final LongSupplier EMPTY = () -> 0L;
    private final LongSupplier rate;
    private final LongSupplier capacity;
    @Nullable
    private final ToLongFunction<ItemStack> stackBasedCapacity;
    @Nullable
    private final ChemicalAttributeValidator validator;

    private ChemicalTankSpec(LongSupplier rate, LongSupplier capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, TriPredicate<@NotNull CHEMICAL, @NotNull AutomationType, @NotNull ItemStack> canInsert, Predicate<@NotNull CHEMICAL> isValid, @Nullable ChemicalAttributeValidator validator, Predicate<@NotNull ItemStack> supportsStack) {
        this(rate, capacity, null, canExtract, canInsert, isValid, validator, supportsStack);
    }

    private ChemicalTankSpec(LongSupplier rate, ToLongFunction<ItemStack> stackBasedCapacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, TriPredicate<@NotNull CHEMICAL, @NotNull AutomationType, @NotNull ItemStack> canInsert, Predicate<@NotNull CHEMICAL> isValid, @Nullable ChemicalAttributeValidator validator, Predicate<@NotNull ItemStack> supportsStack) {
        this(rate, EMPTY, stackBasedCapacity, canExtract, canInsert, isValid, validator, supportsStack);
    }

    private ChemicalTankSpec(LongSupplier rate, LongSupplier capacity, @Nullable ToLongFunction<ItemStack> stackBasedCapacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, TriPredicate<@NotNull CHEMICAL, @NotNull AutomationType, @NotNull ItemStack> canInsert, Predicate<@NotNull CHEMICAL> isValid, @Nullable ChemicalAttributeValidator validator, Predicate<@NotNull ItemStack> supportsStack) {
        super(canExtract, canInsert, isValid, supportsStack);
        this.rate = rate;
        this.capacity = capacity;
        this.stackBasedCapacity = stackBasedCapacity;
        this.validator = validator;
    }

    public <STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> TANK createTank(TankFromSpecCreator<CHEMICAL, STACK, TANK> tankCreator, ItemStack stack) {
        LongSupplier capacity = this.stackBasedCapacity == null ? this.capacity : () -> this.stackBasedCapacity.applyAsLong(stack);
        return tankCreator.create(this.rate, capacity, this.canExtract, (chemical, automationType) -> this.canInsert.test(chemical, (Object)automationType, (Object)stack), this.isValid, this.validator, null);
    }

    public <STACK extends ChemicalStack<CHEMICAL>, TANK extends ComponentBackedChemicalTank<CHEMICAL, STACK, ?>> void addTank(ChemicalTanksBuilder<CHEMICAL, STACK, TANK, ?> builder, ComponentTankFromSpecCreator<CHEMICAL, STACK, TANK> tankCreator) {
        if (this.stackBasedCapacity == null) {
            builder.addTank((type, attachedTo, containerIndex) -> tankCreator.create(attachedTo, containerIndex, this.canExtract, (chemical, automationType) -> this.canInsert.test(chemical, (Object)automationType, (Object)attachedTo), this.isValid, this.rate, this.capacity, this.validator));
        } else {
            builder.addTank((type, attachedTo, containerIndex) -> tankCreator.create(attachedTo, containerIndex, this.canExtract, (chemical, automationType) -> this.canInsert.test(chemical, (Object)automationType, (Object)attachedTo), this.isValid, this.rate, () -> this.stackBasedCapacity.applyAsLong(attachedTo), this.validator));
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> ChemicalTankSpec<CHEMICAL> create(LongSupplier rate, LongSupplier capacity) {
        return new ChemicalTankSpec(rate, capacity, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueTri(), ConstantPredicates.alwaysTrue(), null, ConstantPredicates.alwaysTrue());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> ChemicalTankSpec<CHEMICAL> createFillOnly(LongSupplier rate, LongSupplier capacity, Predicate<@NotNull CHEMICAL> isValid) {
        return ChemicalTankSpec.createFillOnly(rate, capacity, isValid, ConstantPredicates.alwaysTrue());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> ChemicalTankSpec<CHEMICAL> createFillOnly(LongSupplier rate, LongSupplier capacity, Predicate<@NotNull CHEMICAL> isValid, Predicate<@NotNull ItemStack> supportsStack) {
        return new ChemicalTankSpec(rate, capacity, ConstantPredicates.notExternal(), (chemical, automation, stack) -> supportsStack.test((ItemStack)stack), isValid, null, supportsStack);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> ChemicalTankSpec<CHEMICAL> createFillOnly(LongSupplier rate, ToLongFunction<ItemStack> stackBasedCapacity, Predicate<@NotNull CHEMICAL> isValid, Predicate<@NotNull ItemStack> supportsStack) {
        return new ChemicalTankSpec(rate, stackBasedCapacity, ConstantPredicates.notExternal(), (chemical, automation, stack) -> supportsStack.test((ItemStack)stack), isValid, null, supportsStack);
    }

    @FunctionalInterface
    public static interface TankFromSpecCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> {
        public TANK create(LongSupplier var1, LongSupplier var2, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> var3, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> var4, Predicate<@NotNull CHEMICAL> var5, @Nullable ChemicalAttributeValidator var6, @Nullable IContentsListener var7);

        default public TANK create(LongSupplier rate, LongSupplier capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> isValid, @Nullable IContentsListener listener) {
            return this.create(rate, capacity, canExtract, canInsert, isValid, null, listener);
        }

        default public TANK create(LongSupplier rate, LongSupplier capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> isValid) {
            return this.create(rate, capacity, canExtract, canInsert, isValid, null);
        }
    }

    @FunctionalInterface
    public static interface ComponentTankFromSpecCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends ComponentBackedChemicalTank<CHEMICAL, STACK, ?>> {
        public TANK create(ItemStack var1, int var2, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> var3, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> var4, Predicate<@NotNull CHEMICAL> var5, LongSupplier var6, LongSupplier var7, @Nullable ChemicalAttributeValidator var8);

        default public TANK create(ItemStack attachedTo, int tankIndex, LongSupplier rate, LongSupplier capacity, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> isValid) {
            return this.create(attachedTo, tankIndex, canExtract, canInsert, isValid, rate, capacity, null);
        }
    }
}

