/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import java.util.function.BooleanSupplier;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMultiTypeCapability<HANDLER, ITEM_HANDLER extends HANDLER> {
    public BlockCapability<HANDLER, @Nullable Direction> block();

    public ItemCapability<ITEM_HANDLER, Void> item();

    public EntityCapability<HANDLER, ?> entity();

    default public boolean is(BlockCapability<?, ?> capability) {
        return capability == this.block();
    }

    @Nullable
    default public ITEM_HANDLER getCapability(ItemStack stack) {
        return (ITEM_HANDLER)stack.getCapability(this.item());
    }

    default public boolean hasCapability(ItemStack stack) {
        return this.getCapability(stack) != null;
    }

    @Nullable
    default public HANDLER getCapability(@Nullable Entity entity) {
        return (HANDLER)(entity == null ? null : entity.getCapability(this.entity(), null));
    }

    @Nullable
    default public HANDLER getCapabilityIfLoaded(@Nullable Level level, @NotNull BlockPos pos, @Nullable Direction side) {
        return this.getCapabilityIfLoaded(level, pos, null, null, side);
    }

    @Nullable
    default public HANDLER getCapabilityIfLoaded(@Nullable Level level, @NotNull BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction side) {
        return WorldUtils.getCapability(level, this.block(), pos, state, blockEntity, side);
    }

    default public BlockCapabilityCache<HANDLER, @Nullable Direction> createCache(ServerLevel level, BlockPos pos, @Nullable Direction context) {
        return BlockCapabilityCache.create(this.block(), (ServerLevel)level, (BlockPos)pos, (Object)context);
    }

    default public BlockCapabilityCache<HANDLER, @Nullable Direction> createCache(ServerLevel level, BlockPos pos, @Nullable Direction context, BooleanSupplier isValid, Runnable invalidationListener) {
        return BlockCapabilityCache.create(this.block(), (ServerLevel)level, (BlockPos)pos, (Object)context, (BooleanSupplier)isValid, (Runnable)invalidationListener);
    }
}

