/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.prefab;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.prefab.BlockBase;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockTile<TILE extends TileEntityMekanism, TYPE extends BlockTypeTile<TILE>>
extends BlockBase<TYPE>
implements IHasTileEntity<TILE> {
    public BlockTile(TYPE type, UnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
        this(type, (BlockBehaviour.Properties)propertiesModifier.apply(BlockBehaviour.Properties.of().strength(3.5f, 16.0f).requiresCorrectToolForDrops()));
    }

    public BlockTile(TYPE type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    @Override
    public TileEntityTypeRegistryObject<TILE> getTileType() {
        return ((BlockTypeTile)this.type).getTileType();
    }

    @Override
    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, pos);
        if (tile == null) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (world.isClientSide) {
            return this.genericClientActivated(stack, tile);
        }
        return tile.tryWrench(state, player, stack).getInteractionResult();
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return Attribute.has(this, AttributeGui.class) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return tile.openGui(player);
    }

    @Override
    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        AttributeParticleFX particleFX;
        super.animateTick(state, world, pos, random);
        if (MekanismConfig.client.machineEffects.get() && (particleFX = ((BlockTypeTile)this.type).get(AttributeParticleFX.class)) != null && Attribute.isActive(state)) {
            Direction facing = Attribute.getFacing(state);
            for (Function<RandomSource, AttributeParticleFX.Particle> particleFunction : particleFX.getParticleFunctions()) {
                AttributeParticleFX.Particle particle = particleFunction.apply(random);
                Pos3D particlePos = particle.getPos();
                if (facing == Direction.WEST) {
                    particlePos = particlePos.yRot(90.0f);
                } else if (facing == Direction.EAST) {
                    particlePos = particlePos.yRot(270.0f);
                } else if (facing == Direction.NORTH) {
                    particlePos = particlePos.yRot(180.0f);
                }
                particlePos = particlePos.add((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                world.addParticle(particle.getType(), particlePos.x, particlePos.y, particlePos.z, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean isMoving) {
        TileEntityMekanism tile;
        if (!world.isClientSide && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, pos)) != null) {
            tile.onNeighborChange(neighborBlock, neighborPos);
        }
    }

    protected boolean isSignalSource(@NotNull BlockState state) {
        return ((BlockTypeTile)this.type).has(Attributes.AttributeRedstoneEmitter.class);
    }

    public boolean canConnectRedstone(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @Nullable Direction side) {
        return ((BlockTypeTile)this.type).has(Attributes.AttributeRedstoneEmitter.class) || super.canConnectRedstone(state, world, pos, side);
    }

    protected int getSignal(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction side) {
        TileEntityMekanism tile;
        Attributes.AttributeRedstoneEmitter redstoneEmitter = ((BlockTypeTile)this.type).get(Attributes.AttributeRedstoneEmitter.class);
        if (redstoneEmitter != null && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, world, pos)) != null) {
            return redstoneEmitter.getRedstoneLevel(tile, side.getOpposite());
        }
        return super.getSignal(state, world, pos, side);
    }

    public static class BlockTileModel<TILE extends TileEntityMekanism, BLOCK extends BlockTypeTile<TILE>>
    extends BlockTile<TILE, BLOCK>
    implements IStateFluidLoggable {
        public BlockTileModel(BLOCK type, UnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
            super(type, propertiesModifier);
        }

        public BlockTileModel(BLOCK type, BlockBehaviour.Properties properties) {
            super(type, properties);
        }
    }
}

