/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.fluid;

import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.fluid.AttachedFluids;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ComponentBackedFluidTank
extends ComponentBackedContainer<FluidStack, AttachedFluids>
implements IExtendedFluidTank {
    private final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract;
    private final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert;
    private final Predicate<@NotNull FluidStack> validator;
    private final IntSupplier capacity;
    private final IntSupplier rate;

    public ComponentBackedFluidTank(ItemStack attachedTo, int tankIndex, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> validator, IntSupplier rate, IntSupplier capacity) {
        super(attachedTo, tankIndex);
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.capacity = capacity;
        this.rate = rate;
    }

    @Override
    protected FluidStack copy(FluidStack toCopy) {
        return toCopy.copy();
    }

    @Override
    protected boolean isEmpty(FluidStack value) {
        return value.isEmpty();
    }

    @Override
    protected ContainerType<?, AttachedFluids, ?> containerType() {
        return ContainerType.FLUID;
    }

    public FluidStack getFluid() {
        return (FluidStack)this.getContents((AttachedFluids)this.getAttached());
    }

    @Override
    public void setStack(FluidStack stack) {
        this.setStackUnchecked(stack);
    }

    @Override
    public void setStackUnchecked(FluidStack stack) {
        this.setContents((AttachedFluids)this.getAttached(), stack);
    }

    public int getCapacity() {
        return this.capacity.getAsInt();
    }

    protected int getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Integer.MAX_VALUE : this.rate.getAsInt();
    }

    protected int getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Integer.MAX_VALUE : this.rate.getAsInt();
    }

    @Override
    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isFluidValid(stack) || !this.canInsert.test(stack, automationType)) {
            return stack;
        }
        AttachedFluids attachedFluids = (AttachedFluids)this.getAttached();
        FluidStack stored = (FluidStack)this.getContents(attachedFluids);
        int needed = Math.min(this.getInsertRate(automationType), this.getNeeded(stored));
        if (needed <= 0) {
            return stack;
        }
        if (stored.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)stored, (FluidStack)stack)) {
            int toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                this.setContents(attachedFluids, stack.copyWithAmount(stored.getAmount() + toAdd));
            }
            return stack.copyWithAmount(stack.getAmount() - toAdd);
        }
        return stack;
    }

    @Override
    public final FluidStack extract(int amount, Action action, AutomationType automationType) {
        if (amount < 1) {
            return FluidStack.EMPTY;
        }
        AttachedFluids attachedFluids = (AttachedFluids)this.getAttached();
        return this.extract(attachedFluids, (FluidStack)this.getContents(attachedFluids), amount, action, automationType);
    }

    protected FluidStack extract(AttachedFluids attachedFluids, FluidStack stored, int amount, Action action, AutomationType automationType) {
        if (amount < 1 || stored.isEmpty() || !this.canExtract.test(stored, automationType)) {
            return FluidStack.EMPTY;
        }
        int size = Math.min(Math.min(this.getExtractRate(automationType), stored.getAmount()), amount);
        FluidStack ret = stored.copyWithAmount(size);
        if (!ret.isEmpty() && action.execute()) {
            this.setContents(attachedFluids, stored.copyWithAmount(stored.getAmount() - ret.getAmount()));
        }
        return ret;
    }

    @Override
    public final int setStackSize(int amount, Action action) {
        AttachedFluids attachedFluids = (AttachedFluids)this.getAttached();
        return this.setStackSize(attachedFluids, (FluidStack)this.getContents(attachedFluids), amount, action);
    }

    protected int setStackSize(AttachedFluids attachedFluids, FluidStack stored, int amount, Action action) {
        if (stored.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setContents(attachedFluids, FluidStack.EMPTY);
            }
            return 0;
        }
        int maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stored.getAmount() == amount || action.simulate()) {
            return amount;
        }
        this.setContents(attachedFluids, stored.copyWithAmount(amount));
        return amount;
    }

    @Override
    public int growStack(int amount, Action action) {
        AttachedFluids attachedFluids = (AttachedFluids)this.getAttached();
        FluidStack stored = (FluidStack)this.getContents(attachedFluids);
        int current = stored.getAmount();
        if (current == 0) {
            return 0;
        }
        if (amount > 0) {
            amount = Math.min(Math.min(amount, this.getNeeded(stored)), this.getInsertRate(null));
        } else if (amount < 0) {
            amount = Math.max(amount, -this.getExtractRate(null));
        }
        int newSize = this.setStackSize(attachedFluids, stored, current + amount, action);
        return newSize - current;
    }

    protected int getNeeded(FluidStack stored) {
        return Math.max(0, this.getCapacity() - stored.getAmount());
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        FluidStack stored = this.getFluid();
        if (!stored.isEmpty()) {
            nbt.put("stored", stored.save(provider));
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setFluidStackIfPresent(provider, nbt, "stored", this::setStackUnchecked);
    }

    @Override
    @Deprecated
    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        AttachedFluids attachedFluids = (AttachedFluids)this.getAttached();
        FluidStack stored = (FluidStack)this.getContents(attachedFluids);
        if (!stored.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)stored, (FluidStack)stack)) {
            return this.extract(attachedFluids, stored, stack.getAmount(), Action.fromFluidAction(action), AutomationType.EXTERNAL);
        }
        return FluidStack.EMPTY;
    }
}

