/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.energy;

import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.ComponentBackedEnergyContainer;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.machine.TileEntityResistiveHeater;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ComponentBackedResistiveEnergyContainer
extends ComponentBackedEnergyContainer {
    private static final FloatingLongSupplier SUPPLIES_ZERO = () -> FloatingLong.ZERO;

    public static ComponentBackedResistiveEnergyContainer create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int containerIndex) {
        return new ComponentBackedResistiveEnergyContainer(attachedTo, containerIndex);
    }

    private ComponentBackedResistiveEnergyContainer(ItemStack attachedTo, int containerIndex) {
        super(attachedTo, containerIndex, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue, SUPPLIES_ZERO, SUPPLIES_ZERO);
    }

    @Override
    public FloatingLong getMaxEnergy() {
        return this.getEnergyPerTick().multiply(400L);
    }

    private FloatingLong getRate() {
        return this.getMaxEnergy().multiply(0.005);
    }

    @Override
    protected FloatingLong getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? FloatingLong.MAX_VALUE : this.getRate();
    }

    @Override
    protected FloatingLong getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? FloatingLong.MAX_VALUE : this.getRate();
    }

    private FloatingLong getEnergyPerTick() {
        return (FloatingLong)this.attachedTo.getOrDefault(MekanismDataComponents.ENERGY_USAGE, (Object)TileEntityResistiveHeater.BASE_USAGE);
    }

    private void updateEnergyUsage(FloatingLong energyUsage) {
        this.attachedTo.set(MekanismDataComponents.ENERGY_USAGE, (Object)energyUsage);
        this.setEnergy(this.getEnergy());
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        nbt.putString("energy_usage", this.getEnergyPerTick().toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setFloatingLongIfPresent(nbt, "energy_usage", this::updateEnergyUsage);
        super.deserializeNBT(provider, nbt);
    }
}

