/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.energy;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.ComponentBackedEnergyContainer;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.item.block.ItemBlockEnergyCube;
import mekanism.common.tier.EnergyCubeTier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class ComponentBackedEnergyCubeContainer
extends ComponentBackedEnergyContainer {
    private final boolean isCreative;

    public static ComponentBackedEnergyCubeContainer create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int containerIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ItemBlockEnergyCube)) {
            throw new IllegalStateException("Attached to should always be an energy cube item");
        }
        ItemBlockEnergyCube item2 = (ItemBlockEnergyCube)item;
        return new ComponentBackedEnergyCubeContainer(attachedTo, containerIndex, item2.getTier());
    }

    private ComponentBackedEnergyCubeContainer(ItemStack attachedTo, int containerIndex, EnergyCubeTier tier) {
        super(attachedTo, containerIndex, BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.alwaysTrue, tier::getOutput, tier::getMaxEnergy);
        this.isCreative = tier == EnergyCubeTier.CREATIVE;
    }

    @Override
    public FloatingLong insert(FloatingLong amount, Action action, AutomationType automationType) {
        return super.insert(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }
}

