/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.energy;

import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.AttachedEnergy;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ComponentBackedEnergyContainer
extends ComponentBackedContainer<FloatingLong, AttachedEnergy>
implements IEnergyContainer {
    private final Predicate<@NotNull AutomationType> canExtract;
    private final Predicate<@NotNull AutomationType> canInsert;
    private final FloatingLongSupplier maxEnergy;
    private final FloatingLongSupplier rate;

    public ComponentBackedEnergyContainer(ItemStack attachedTo, int containerIndex, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, FloatingLongSupplier rate, FloatingLongSupplier maxEnergy) {
        super(attachedTo, containerIndex);
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.maxEnergy = maxEnergy;
        this.rate = rate;
    }

    @Override
    protected FloatingLong copy(FloatingLong toCopy) {
        return toCopy.copyAsConst();
    }

    @Override
    protected boolean isEmpty(FloatingLong value) {
        return value.isZero();
    }

    @Override
    protected ContainerType<?, AttachedEnergy, ?> containerType() {
        return ContainerType.ENERGY;
    }

    @Override
    public FloatingLong getEnergy() {
        return (FloatingLong)this.getContents((AttachedEnergy)this.getAttached());
    }

    @Override
    public void setEnergy(FloatingLong energy) {
        this.setContents((AttachedEnergy)this.getAttached(), energy);
    }

    protected FloatingLong clampEnergy(FloatingLong energy) {
        return energy.min(this.getMaxEnergy());
    }

    @Override
    protected void setContents(AttachedEnergy attachedEnergy, FloatingLong energy) {
        super.setContents(attachedEnergy, this.clampEnergy(energy));
    }

    protected FloatingLong getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? FloatingLong.MAX_VALUE : this.rate.get();
    }

    protected FloatingLong getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? FloatingLong.MAX_VALUE : this.rate.get();
    }

    @Override
    public FloatingLong insert(FloatingLong amount, Action action, AutomationType automationType) {
        if (amount.isZero() || !this.canInsert.test(automationType)) {
            return amount;
        }
        AttachedEnergy attachedEnergy = (AttachedEnergy)this.getAttached();
        FloatingLong stored = (FloatingLong)this.getContents(attachedEnergy);
        FloatingLong needed = this.getInsertRate(automationType).min(this.getNeeded(stored));
        if (needed.isZero()) {
            return amount;
        }
        FloatingLong toAdd = amount.min(needed);
        if (!toAdd.isZero() && action.execute()) {
            this.setContents(attachedEnergy, stored.add(toAdd));
        }
        return amount.subtract(toAdd);
    }

    @Override
    public FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType) {
        if (amount.isZero()) {
            return FloatingLong.ZERO;
        }
        AttachedEnergy attachedEnergy = (AttachedEnergy)this.getAttached();
        FloatingLong stored = (FloatingLong)this.getContents(attachedEnergy);
        if (stored.isZero() || !this.canExtract.test(automationType)) {
            return FloatingLong.ZERO;
        }
        FloatingLong ret = this.getExtractRate(automationType).min(stored).min(amount).copy();
        if (!ret.isZero() && action.execute()) {
            this.setContents(attachedEnergy, stored.subtract(ret));
        }
        return ret;
    }

    protected FloatingLong getNeeded(FloatingLong stored) {
        return this.getMaxEnergy().subtract(stored);
    }

    @Override
    public FloatingLong getMaxEnergy() {
        return this.maxEnergy.get();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        FloatingLong stored = this.getEnergy();
        if (!stored.isZero()) {
            nbt.putString("stored", stored.toString());
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setFloatingLongIfPresent(nbt, "stored", this::setEnergy);
    }
}

