/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical.slurry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.attachments.containers.IAttachedContainers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public record AttachedSlurries(List<SlurryStack> containers) implements IAttachedContainers<SlurryStack, AttachedSlurries>
{
    public static final AttachedSlurries EMPTY = new AttachedSlurries(Collections.emptyList());
    public static final Codec<AttachedSlurries> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SlurryStack.OPTIONAL_CODEC.listOf().fieldOf("slurry_tanks").forGetter(AttachedSlurries::containers)).apply((Applicative)instance, AttachedSlurries::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttachedSlurries> STREAM_CODEC = SlurryStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).map(AttachedSlurries::new, AttachedSlurries::containers);

    public AttachedSlurries {
        containers = Collections.unmodifiableList(containers);
    }

    public static AttachedSlurries create(int containers) {
        return new AttachedSlurries((List<SlurryStack>)NonNullList.withSize((int)containers, (Object)SlurryStack.EMPTY));
    }

    @Override
    public SlurryStack getEmptyStack() {
        return SlurryStack.EMPTY;
    }

    @Override
    public AttachedSlurries create(List<SlurryStack> containers) {
        return new AttachedSlurries(containers);
    }
}

