/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical.pigment;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.pigment.AttachedPigments;
import mekanism.common.attachments.containers.chemical.pigment.ComponentBackedPigmentTank;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.tier.ChemicalTankTier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class ComponentBackedChemicalTankPigmentTank
extends ComponentBackedPigmentTank {
    private final boolean isCreative;

    public static ComponentBackedChemicalTankPigmentTank create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int tankIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ItemBlockChemicalTank)) {
            throw new IllegalStateException("Attached to should always be a chemical tank item");
        }
        ItemBlockChemicalTank item2 = (ItemBlockChemicalTank)item;
        return new ComponentBackedChemicalTankPigmentTank(attachedTo, tankIndex, item2.getTier());
    }

    private ComponentBackedChemicalTankPigmentTank(ItemStack attachedTo, int tankIndex, ChemicalTankTier tier) {
        super(attachedTo, tankIndex, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrueBi, ChemicalTankBuilder.PIGMENT.alwaysTrue, tier::getOutput, tier::getStorage, tier == ChemicalTankTier.CREATIVE ? ChemicalAttributeValidator.ALWAYS_ALLOW : null);
        this.isCreative = tier == ChemicalTankTier.CREATIVE;
    }

    @Override
    public PigmentStack insert(PigmentStack stack, Action action, AutomationType automationType) {
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public PigmentStack extract(AttachedPigments attachedPigments, PigmentStack stored, long amount, Action action, AutomationType automationType) {
        return super.extract(attachedPigments, stored, amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public long setStackSize(AttachedPigments attachedPigments, PigmentStack stored, long amount, Action action) {
        return super.setStackSize(attachedPigments, stored, amount, action.combine(!this.isCreative));
    }
}

