/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical.merged;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.gas.ComponentBackedGasTank;
import mekanism.common.attachments.containers.chemical.infuse.ComponentBackedInfusionTank;
import mekanism.common.attachments.containers.chemical.pigment.ComponentBackedPigmentTank;
import mekanism.common.attachments.containers.chemical.slurry.ComponentBackedSlurryTank;
import mekanism.common.attachments.containers.creator.IBasicContainerCreator;
import mekanism.common.attachments.containers.fluid.ComponentBackedFluidTank;
import mekanism.common.capabilities.merged.MergedTank;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MergedTankCreator
implements IBasicContainerCreator {
    private final IBasicContainerCreator<? extends ComponentBackedGasTank> gasCreator;
    private final IBasicContainerCreator<? extends ComponentBackedInfusionTank> infusionCreator;
    private final IBasicContainerCreator<? extends ComponentBackedPigmentTank> pigmentCreator;
    private final IBasicContainerCreator<? extends ComponentBackedSlurryTank> slurryCreator;
    @Nullable
    private final IBasicContainerCreator<? extends ComponentBackedFluidTank> fluidCreator;

    public MergedTankCreator(IBasicContainerCreator<? extends ComponentBackedGasTank> gasCreator, IBasicContainerCreator<? extends ComponentBackedInfusionTank> infusionCreator, IBasicContainerCreator<? extends ComponentBackedPigmentTank> pigmentCreator, IBasicContainerCreator<? extends ComponentBackedSlurryTank> slurryCreator) {
        this(gasCreator, infusionCreator, pigmentCreator, slurryCreator, null);
    }

    public MergedTankCreator(IBasicContainerCreator<? extends ComponentBackedGasTank> gasCreator, IBasicContainerCreator<? extends ComponentBackedInfusionTank> infusionCreator, IBasicContainerCreator<? extends ComponentBackedPigmentTank> pigmentCreator, IBasicContainerCreator<? extends ComponentBackedSlurryTank> slurryCreator, @Nullable IBasicContainerCreator<? extends ComponentBackedFluidTank> fluidCreator) {
        this.gasCreator = gasCreator;
        this.infusionCreator = infusionCreator;
        this.pigmentCreator = pigmentCreator;
        this.slurryCreator = slurryCreator;
        this.fluidCreator = fluidCreator;
    }

    private MergedChemicalTank createMergedTank(ContainerType containerType, ItemStack attachedTo, int containerIndex) {
        if (this.fluidCreator == null) {
            return MergedChemicalTank.create(this.gasCreator.create(containerType, attachedTo, containerIndex), this.infusionCreator.create(containerType, attachedTo, containerIndex), this.pigmentCreator.create(containerType, attachedTo, containerIndex), this.slurryCreator.create(containerType, attachedTo, containerIndex));
        }
        return MergedTank.create(this.fluidCreator.create(containerType, attachedTo, containerIndex), this.gasCreator.create(containerType, attachedTo, containerIndex), this.infusionCreator.create(containerType, attachedTo, containerIndex), this.pigmentCreator.create(containerType, attachedTo, containerIndex), this.slurryCreator.create(containerType, attachedTo, containerIndex));
    }

    public INBTSerializable<CompoundTag> create(ContainerType containerType, ItemStack attachedTo, int containerIndex) {
        if (containerType == ContainerType.FLUID) {
            if (this.fluidCreator != null) {
                return ((MergedTank)this.createMergedTank(containerType, attachedTo, containerIndex)).getFluidTank();
            }
        } else {
            if (containerType == ContainerType.GAS) {
                return this.createMergedTank(containerType, attachedTo, containerIndex).getGasTank();
            }
            if (containerType == ContainerType.INFUSION) {
                return this.createMergedTank(containerType, attachedTo, containerIndex).getInfusionTank();
            }
            if (containerType == ContainerType.PIGMENT) {
                return this.createMergedTank(containerType, attachedTo, containerIndex).getPigmentTank();
            }
            if (containerType == ContainerType.SLURRY) {
                return this.createMergedTank(containerType, attachedTo, containerIndex).getSlurryTank();
            }
        }
        throw new IllegalStateException("Unexpected container type " + String.valueOf(containerType.getComponentName()) + " for merged tank creation");
    }
}

