/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public record BlockData(BlockState blockState, @Nullable CompoundTag blockEntityTag) {
    public static final Codec<BlockData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(BlockData::blockState), (App)CompoundTag.CODEC.optionalFieldOf("block_entity_tag").forGetter(data -> Optional.ofNullable(data.blockEntityTag))).apply((Applicative)instance, (state, tag) -> new BlockData((BlockState)state, tag.orElse(null))));
    public static final StreamCodec<ByteBuf, BlockData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodecTrusted((Codec)BlockState.CODEC), BlockData::blockState, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.TRUSTED_COMPOUND_TAG), data -> Optional.ofNullable(data.blockEntityTag()), (state, tag) -> new BlockData((BlockState)state, tag.orElse(null)));

    public BlockData(HolderLookup.Provider provider, BlockState state, @Nullable BlockEntity blockEntity) {
        this(state, blockEntity == null ? null : blockEntity.saveWithFullMetadata(provider));
    }

    public boolean tryPlaceIntoWorld(Level level, BlockPos pos, @Nullable Player player) {
        BlockState adjustedState = Block.updateFromNeighbourShapes((BlockState)this.blockState, (LevelAccessor)level, (BlockPos)pos);
        if (adjustedState.isAir()) {
            return false;
        }
        FluidState fluidState = adjustedState.getFluidState();
        FluidType fluidType = fluidState.getFluidType();
        FluidStack fluid = new FluidStack(fluidState.getType(), 1000);
        BucketPickup tryPickup = null;
        if (fluidType.isVaporizedOnPlacement(level, pos, fluid)) {
            Block block;
            if (!MekanismConfig.general.strictUnboxing.get() && (block = adjustedState.getBlock()) instanceof BucketPickup) {
                BucketPickup pickup;
                tryPickup = pickup = (BucketPickup)block;
            } else {
                return false;
            }
        }
        level.setBlockAndUpdate(pos, adjustedState);
        if (this.blockEntityTag != null) {
            this.blockEntityTag.putInt("x", pos.getX());
            this.blockEntityTag.putInt("y", pos.getY());
            this.blockEntityTag.putInt("z", pos.getZ());
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, pos);
            if (tile != null) {
                tile.loadWithComponents(this.blockEntityTag, (HolderLookup.Provider)level.registryAccess());
            }
        }
        if (tryPickup != null && !tryPickup.pickupBlock(player, (LevelAccessor)level, pos, adjustedState).isEmpty()) {
            fluidType.onVaporize(null, level, pos, fluid);
        }
        return true;
    }

    public void addToTooltip(Consumer<Component> consumer) {
        Block block = this.blockState.getBlock();
        consumer.accept((Component)MekanismLang.BLOCK.translateColored(EnumColor.INDIGO, EnumColor.GRAY, block));
        if (this.blockEntityTag != null) {
            Optional blockEntityType = RegistryUtils.getById(this.blockEntityTag, BuiltInRegistries.BLOCK_ENTITY_TYPE);
            MekanismLang beName = blockEntityType.isPresent() ? RegistryUtils.getName((BlockEntityType)blockEntityType.get()) : MekanismLang.UNKNOWN;
            consumer.accept((Component)MekanismLang.BLOCK_ENTITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, beName));
            if (this.blockEntityTag != null) {
                PotDecorations decorations;
                if (block instanceof SpawnerBlock || block instanceof TrialSpawnerBlock) {
                    String key = block instanceof SpawnerBlock ? "SpawnData" : "spawn_data";
                    RegistryUtils.getById(this.blockEntityTag.getCompound(key).getCompound("entity"), BuiltInRegistries.ENTITY_TYPE).map(entity -> MekanismLang.BLOCK_ENTITY_SPAWN_TYPE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, entity)).ifPresent(consumer);
                } else if (block instanceof DecoratedPotBlock && !(decorations = PotDecorations.load((CompoundTag)this.blockEntityTag)).equals((Object)PotDecorations.EMPTY)) {
                    consumer.accept((Component)MekanismLang.BLOCK_ENTITY_DECORATION.translateColored(EnumColor.INDIGO));
                    Stream.of(decorations.front(), decorations.left(), decorations.right(), decorations.back()).map(decoration -> MekanismLang.GENERIC_LIST.translateColored(EnumColor.INDIGO, EnumColor.GRAY, decoration)).forEach(consumer);
                }
            }
        }
    }
}

