/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Supplier;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.lib.effect.CustomEffect;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BillboardingEffectRenderer {
    private BillboardingEffectRenderer() {
    }

    public static void render(CustomEffect effect, String profilerSection) {
        BillboardingEffectRenderer.render(effect.getTexture(), profilerSection, () -> effect);
    }

    public static void render(ResourceLocation texture, final String profilerSection, final Supplier<CustomEffect> lazyEffect) {
        final RenderType renderType = MekanismRenderType.SPS.apply(texture);
        RenderTickHandler.addTransparentRenderer(new RenderTickHandler.LazyRender(){

            @Override
            public void render(Camera camera, VertexConsumer renderer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                BillboardingEffectRenderer.render(camera, renderer, poseStack, renderTick, partialTick, (CustomEffect)lazyEffect.get());
            }

            @Override
            @NotNull
            public Vec3 getCenterPos(float partialTick) {
                return ((CustomEffect)lazyEffect.get()).getPos(partialTick);
            }

            @Override
            @NotNull
            public String getProfilerSection() {
                return profilerSection;
            }

            @Override
            @NotNull
            public RenderType getRenderType() {
                return renderType;
            }
        });
    }

    private static void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, CustomEffect effect) {
        int gridSize = effect.getTextureGridSize();
        int tick = renderTick % (gridSize * gridSize);
        int xIndex = tick % gridSize;
        int yIndex = tick / gridSize;
        float spriteSize = 1.0f / (float)gridSize;
        Quaternionf quaternion = camera.rotation();
        Vector3f[] vertexPos = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        Vec3 pos = effect.getPos(partialTick).subtract(camera.getPosition());
        for (Vector3f vector3f : vertexPos) {
            quaternion.transform(vector3f);
            vector3f.mul(effect.getScale());
            vector3f.add((float)pos.x(), (float)pos.y(), (float)pos.z());
        }
        int[] color = effect.getColor().rgbaArray();
        float minU = (float)xIndex * spriteSize;
        float maxU = minU + spriteSize;
        float minV = (float)yIndex * spriteSize;
        float maxV = minV + spriteSize;
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, vertexPos[0].x(), vertexPos[0].y(), vertexPos[0].z()).setUv(minU, maxV).setColor(color[0], color[1], color[2], color[3]);
        buffer.addVertex(matrix, vertexPos[1].x(), vertexPos[1].y(), vertexPos[1].z()).setUv(maxU, maxV).setColor(color[0], color[1], color[2], color[3]);
        buffer.addVertex(matrix, vertexPos[2].x(), vertexPos[2].y(), vertexPos[2].z()).setUv(maxU, minV).setColor(color[0], color[1], color[2], color[3]);
        buffer.addVertex(matrix, vertexPos[3].x(), vertexPos[3].y(), vertexPos[3].z()).setUv(minU, minV).setColor(color[0], color[1], color[2], color[3]);
        poseStack.popPose();
    }
}

