/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;

public class TransmitterTypeDecorator
implements IItemDecorator {
    private final ResourceLocation texture;

    public static void registerDecorators(RegisterItemDecorationsEvent event, IBlockProvider ... blocks) {
        for (IBlockProvider block : blocks) {
            event.register((ItemLike)block, (IItemDecorator)new TransmitterTypeDecorator(block));
        }
    }

    private TransmitterTypeDecorator(IBlockProvider block) {
        this.texture = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ICONS, block.getRegistryName().getPath() + ".png");
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (stack.isEmpty()) {
            return false;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        guiGraphics.blit(this.texture, xOffset, yOffset, 0.0f, 0.0f, 16, 16, 16, 16);
        pose.popPose();
        return true;
    }
}

