/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import mekanism.client.render.armor.FreeRunnerArmor;
import mekanism.client.render.armor.ICustomArmor;
import mekanism.client.render.armor.ISpecialGear;
import mekanism.client.render.armor.JetpackArmor;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.client.render.armor.ScubaMaskArmor;
import mekanism.client.render.armor.ScubaTankArmor;
import mekanism.client.render.item.block.RenderEnergyCubeItem;
import mekanism.client.render.item.block.RenderFluidTankItem;
import mekanism.client.render.item.gear.RenderAtomicDisassembler;
import mekanism.client.render.item.gear.RenderFlameThrower;
import mekanism.client.render.item.gear.RenderFreeRunners;
import mekanism.client.render.item.gear.RenderJetpack;
import mekanism.client.render.item.gear.RenderScubaMask;
import mekanism.client.render.item.gear.RenderScubaTank;
import mekanism.common.block.BlockBounding;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class RenderPropertiesProvider {
    private static final ISpecialGear MEKA_SUIT = type -> switch (type) {
        case ArmorItem.Type.HELMET -> MekaSuitArmor.HELMET;
        case ArmorItem.Type.CHESTPLATE -> MekaSuitArmor.BODYARMOR;
        case ArmorItem.Type.LEGGINGS -> MekaSuitArmor.PANTS;
        case ArmorItem.Type.BOOTS -> MekaSuitArmor.BOOTS;
        default -> throw new IllegalStateException("No model present for registered meka suit piece of type " + String.valueOf(type));
    };
    private static final IClientBlockExtensions PARTICLE_HANDLER = new IClientBlockExtensions(){

        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            state.getShape((BlockGetter)Level2, pos).forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double xDif = Math.min(1.0, maxX - minX);
                double yDif = Math.min(1.0, maxY - minY);
                double zDif = Math.min(1.0, maxZ - minZ);
                int xCount = Mth.ceil((double)(xDif / 0.25));
                int yCount = Mth.ceil((double)(yDif / 0.25));
                int zCount = Mth.ceil((double)(zDif / 0.25));
                if (xCount > 0 && yCount > 0 && zCount > 0) {
                    for (int x = 0; x < xCount; ++x) {
                        for (int y = 0; y < yCount; ++y) {
                            for (int z = 0; z < zCount; ++z) {
                                double d4 = ((double)x + 0.5) / (double)xCount;
                                double d5 = ((double)y + 0.5) / (double)yCount;
                                double d6 = ((double)z + 0.5) / (double)zCount;
                                double d7 = d4 * xDif + minX;
                                double d8 = d5 * yDif + minY;
                                double d9 = d6 * zDif + minZ;
                                manager.add((Particle)new TerrainParticle((ClientLevel)Level2, (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).updateSprite(state, pos));
                            }
                        }
                    }
                }
            });
            return true;
        }
    };

    private RenderPropertiesProvider() {
    }

    public static IClientItemExtensions energyCube() {
        return new MekRenderProperties(RenderEnergyCubeItem.RENDERER);
    }

    public static IClientItemExtensions fluidTank() {
        return new MekRenderProperties(RenderFluidTankItem.RENDERER);
    }

    public static IClientItemExtensions armoredJetpack() {
        return new MekCustomArmorRenderProperties(RenderJetpack.ARMORED_RENDERER, JetpackArmor.ARMORED_JETPACK);
    }

    public static IClientItemExtensions jetpack() {
        return new MekCustomArmorRenderProperties(RenderJetpack.RENDERER, JetpackArmor.JETPACK);
    }

    public static IClientItemExtensions disassembler() {
        return new MekRenderProperties(RenderAtomicDisassembler.RENDERER);
    }

    public static IClientItemExtensions flamethrower() {
        return new MekRenderProperties(RenderFlameThrower.RENDERER);
    }

    public static IClientItemExtensions armoredFreeRunners() {
        return new MekCustomArmorRenderProperties(RenderFreeRunners.ARMORED_RENDERER, FreeRunnerArmor.ARMORED_FREE_RUNNERS);
    }

    public static IClientItemExtensions freeRunners() {
        return new MekCustomArmorRenderProperties(RenderFreeRunners.RENDERER, FreeRunnerArmor.FREE_RUNNERS);
    }

    public static IClientItemExtensions scubaMask() {
        return new MekCustomArmorRenderProperties(RenderScubaMask.RENDERER, ScubaMaskArmor.SCUBA_MASK);
    }

    public static IClientItemExtensions scubaTank() {
        return new MekCustomArmorRenderProperties(RenderScubaTank.RENDERER, ScubaTankArmor.SCUBA_TANK);
    }

    public static IClientItemExtensions mekaSuit() {
        return MEKA_SUIT;
    }

    public static IClientBlockExtensions particles() {
        return PARTICLE_HANDLER;
    }

    public static IClientBlockExtensions boundingParticles() {
        return new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
                BlockState mainState;
                BlockHitResult blockTarget;
                BlockPos pos;
                BlockPos mainPos;
                if (target.getType() == HitResult.Type.BLOCK && target instanceof BlockHitResult && (mainPos = BlockBounding.getMainBlockPos((BlockGetter)world, pos = (blockTarget = (BlockHitResult)target).getBlockPos())) != null && !(mainState = world.getBlockState(mainPos)).isAir()) {
                    AABB axisalignedbb = state.getShape((BlockGetter)world, pos).bounds();
                    double x = (double)pos.getX() + world.random.nextDouble() * (axisalignedbb.maxX - axisalignedbb.minX - 0.2) + 0.1 + axisalignedbb.minX;
                    double y = (double)pos.getY() + world.random.nextDouble() * (axisalignedbb.maxY - axisalignedbb.minY - 0.2) + 0.1 + axisalignedbb.minY;
                    double z = (double)pos.getZ() + world.random.nextDouble() * (axisalignedbb.maxZ - axisalignedbb.minZ - 0.2) + 0.1 + axisalignedbb.minZ;
                    Direction side = blockTarget.getDirection();
                    switch (side) {
                        case DOWN: {
                            y = (double)pos.getY() + axisalignedbb.minY - 0.1;
                            break;
                        }
                        case UP: {
                            y = (double)pos.getY() + axisalignedbb.maxY + 0.1;
                            break;
                        }
                        case NORTH: {
                            z = (double)pos.getZ() + axisalignedbb.minZ - 0.1;
                            break;
                        }
                        case SOUTH: {
                            z = (double)pos.getZ() + axisalignedbb.maxZ + 0.1;
                            break;
                        }
                        case WEST: {
                            x = (double)pos.getX() + axisalignedbb.minX - 0.1;
                            break;
                        }
                        case EAST: {
                            x = (double)pos.getX() + axisalignedbb.maxX + 0.1;
                        }
                    }
                    manager.add(new TerrainParticle((ClientLevel)world, x, y, z, 0.0, 0.0, 0.0, mainState).updateSprite(mainState, mainPos).setPower(0.2f).scale(0.6f));
                    return true;
                }
                return false;
            }
        };
    }

    public record MekRenderProperties(BlockEntityWithoutLevelRenderer renderer) implements IClientItemExtensions
    {
        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.renderer;
        }
    }

    public record MekCustomArmorRenderProperties(BlockEntityWithoutLevelRenderer renderer, ICustomArmor gearModel) implements ISpecialGear
    {
        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.renderer;
        }

        @Override
        @NotNull
        public ICustomArmor getGearModel(ArmorItem.Type type) {
            return this.gearModel;
        }
    }
}

