/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.ArrayList;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class PressurizedReactionRecipeCategory
extends HolderRecipeCategory<PressurizedReactionRecipe> {
    private static final String OUTPUT_GAS = "outputGas";
    private final GuiGauge<?> inputGas;
    private final GuiGauge<?> inputFluid;
    private final GuiSlot inputItem = this.addSlot(SlotType.INPUT, 54, 35);
    private final GuiSlot outputItem = this.addSlot(SlotType.OUTPUT, 116, 35);
    private final GuiGauge<?> outputGas;

    public PressurizedReactionRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<PressurizedReactionRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 141, 17).with(SlotOverlay.POWER);
        this.inputFluid = this.addElement(GuiFluidGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 5, 10));
        this.inputGas = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 28, 10));
        this.outputGas = this.addElement(GuiGasGauge.getDummy(GaugeType.SMALL.with(DataType.OUTPUT), this, 140, 40));
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 15));
        this.addSimpleProgress(ProgressType.RIGHT, 77, 38);
    }

    @Override
    protected void renderElements(RecipeHolder<PressurizedReactionRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, int x, int y) {
        super.renderElements(recipeHolder, recipeSlotsView, guiGraphics, x, y);
        if (recipeSlotsView.findSlotByName(OUTPUT_GAS).isEmpty()) {
            this.outputGas.drawBarOverlay(guiGraphics);
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<PressurizedReactionRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        PressurizedReactionRecipe recipe = (PressurizedReactionRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.inputItem, recipe.getInputSolid().getRepresentations());
        this.initFluid(builder, RecipeIngredientRole.INPUT, this.inputFluid, recipe.getInputFluid().getRepresentations());
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, this.inputGas, recipe.getInputGas().getRepresentations());
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
        ArrayList<GasStack> gasOutputs = new ArrayList<GasStack>();
        for (PressurizedReactionRecipe.PressurizedReactionRecipeOutput output : recipe.getOutputDefinition()) {
            itemOutputs.add(output.item());
            gasOutputs.add(output.gas());
        }
        if (!itemOutputs.stream().allMatch(ConstantPredicates.ITEM_EMPTY)) {
            this.initItem(builder, RecipeIngredientRole.OUTPUT, this.outputItem, itemOutputs);
        }
        if (!gasOutputs.stream().allMatch(ConstantPredicates.chemicalEmpty())) {
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, this.outputGas, gasOutputs).setSlotName(OUTPUT_GAS);
        }
    }
}

