/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.color.PaintingColorDetails;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class PaintingRecipeCategory
extends HolderRecipeCategory<PaintingRecipe> {
    private static final String PIGMENT_INPUT = "pigmentInput";
    private final PaintingColorDetails colorDetails;
    private final GuiGauge<?> inputPigment;
    private final GuiSlot inputSlot = this.addSlot(SlotType.INPUT, 45, 35);
    private final GuiSlot output;

    public PaintingRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<PaintingRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 144, 35).with(SlotOverlay.POWER);
        this.output = this.addSlot(SlotType.OUTPUT, 116, 35);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 15));
        this.inputPigment = this.addElement(GuiPigmentGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 25, 13));
        this.colorDetails = new PaintingColorDetails();
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 64, 39).colored(this.colorDetails);
    }

    @Override
    public void draw(RecipeHolder<PaintingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.colorDetails.setIngredient(this.getDisplayedStack(recipeSlotsView, PIGMENT_INPUT, MekanismJEI.TYPE_PIGMENT, PigmentStack.EMPTY));
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.colorDetails.reset();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<PaintingRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        PaintingRecipe recipe = (PaintingRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.inputSlot, recipe.getItemInput().getRepresentations());
        this.initChemical(builder, MekanismJEI.TYPE_PIGMENT, RecipeIngredientRole.INPUT, this.inputPigment, recipe.getChemicalInput().getRepresentations()).setSlotName(PIGMENT_INPUT);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
    }
}

