/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.Collections;
import java.util.List;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.lib.Color;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class NucleosynthesizingRecipeCategory
extends HolderRecipeCategory<NucleosynthesizingRecipe> {
    private final GuiDynamicHorizontalRateBar rateBar;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 26, 40);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 6, 69);
    private final GuiSlot output = this.addSlot(SlotType.OUTPUT, 152, 40);
    private final GuiGauge<?> gasInput;

    public NucleosynthesizingRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<NucleosynthesizingRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 173, 69).with(SlotOverlay.POWER);
        this.addElement(new GuiInnerScreen(this, 45, 18, 104, 68));
        this.gasInput = this.addElement(GuiGasGauge.getDummy(GaugeType.SMALL_MED.with(DataType.INPUT), this, 5, 18));
        this.addElement(new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(this){

            @Override
            public FloatingLong getEnergy() {
                return FloatingLong.ONE;
            }

            @Override
            public FloatingLong getMaxEnergy() {
                return FloatingLong.ONE;
            }
        }, GaugeType.SMALL_MED, (IGuiWrapper)this, 172, 18));
        this.rateBar = this.addElement(new GuiDynamicHorizontalRateBar((IGuiWrapper)this, this.getBarProgressTimer(), 5, 88, 183, Color.ColorFunction.scale(Color.rgbi(60, 45, 74), Color.rgbi(100, 30, 170))));
    }

    public List<Component> getTooltipStrings(RecipeHolder<NucleosynthesizingRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.rateBar.isMouseOver(mouseX, mouseY)) {
            return Collections.singletonList(MekanismLang.TICKS_REQUIRED.translate(((NucleosynthesizingRecipe)recipeHolder.value()).getDuration()));
        }
        return Collections.emptyList();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<NucleosynthesizingRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        NucleosynthesizingRecipe recipe = (NucleosynthesizingRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        List<@NotNull STACK> gasInputs = recipe.getChemicalInput().getRepresentations();
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, this.gasInput, gasInputs);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, RecipeViewerUtils.getStacksFor(recipe.getChemicalInput(), true));
    }
}

