/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.machine.GuiChemicalCrystallizer;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalCrystallizerRecipeCategory
extends HolderRecipeCategory<ChemicalCrystallizerRecipe> {
    private static final String CHEMICAL_INPUT = "chemicalInput";
    private static final String DISPLAYED_ITEM = "displayedItem";
    private final OreInfo oreInfo = new OreInfo();
    private final GuiGauge<?> gauge = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 7, 4));
    private final GuiSlot output;
    private final GuiSlot slurryOreSlot;

    public ChemicalCrystallizerRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<ChemicalCrystallizerRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.INPUT, 8, 65).with(SlotOverlay.PLUS);
        this.output = this.addSlot(SlotType.OUTPUT, 129, 57);
        this.addSimpleProgress(ProgressType.LARGE_RIGHT, 53, 61);
        this.addElement(new GuiInnerScreen((IGuiWrapper)this, 31, 13, 115, 42, () -> GuiChemicalCrystallizer.getScreenRenderStrings(this.oreInfo)));
        this.slurryOreSlot = this.addElement(new GuiSlot(SlotType.ORE, this, 128, 13).setRenderAboveSlots());
    }

    @Override
    public void draw(RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.oreInfo.currentRecipe = (ChemicalCrystallizerRecipe)recipeHolder.value();
        this.oreInfo.ingredient = recipeSlotsView.findSlotByName(CHEMICAL_INPUT).flatMap(IRecipeSlotView::getDisplayedIngredient).map(ITypedIngredient::getIngredient).filter(ingredient -> ingredient instanceof ChemicalStack).orElse(null);
        this.oreInfo.itemIngredient = this.getDisplayedStack(recipeSlotsView, DISPLAYED_ITEM, VanillaTypes.ITEM_STACK, ItemStack.EMPTY);
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.oreInfo.currentRecipe = null;
        this.oreInfo.ingredient = null;
        this.oreInfo.itemIngredient = ItemStack.EMPTY;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ChemicalStackIngredient<?, ?, ?> input;
        ChemicalCrystallizerRecipe recipe = (ChemicalCrystallizerRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        ChemicalStackIngredient<?, ?, ?> chemicalStackIngredient = input = recipe.getInput();
        Objects.requireNonNull(chemicalStackIngredient);
        ChemicalStackIngredient<?, ?, ?> chemicalStackIngredient2 = chemicalStackIngredient;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GasStackIngredient.class, InfusionStackIngredient.class, PigmentStackIngredient.class, SlurryStackIngredient.class}, chemicalStackIngredient2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GasStackIngredient ingredient = (GasStackIngredient)chemicalStackIngredient2;
                this.initChemical(builder, MekanismJEI.TYPE_GAS, ingredient);
                break;
            }
            case 1: {
                InfusionStackIngredient ingredient = (InfusionStackIngredient)chemicalStackIngredient2;
                this.initChemical(builder, MekanismJEI.TYPE_INFUSION, ingredient);
                break;
            }
            case 2: {
                PigmentStackIngredient ingredient = (PigmentStackIngredient)chemicalStackIngredient2;
                this.initChemical(builder, MekanismJEI.TYPE_PIGMENT, ingredient);
                break;
            }
            case 3: {
                SlurryStackIngredient ingredient = (SlurryStackIngredient)chemicalStackIngredient2;
                this.initChemical(builder, MekanismJEI.TYPE_SLURRY, ingredient);
                List<ItemStack> displayItems = RecipeViewerUtils.getDisplayItems(ingredient);
                if (displayItems.isEmpty()) break;
                this.initItem(builder, RecipeIngredientRole.RENDER_ONLY, this.slurryOreSlot, displayItems).setSlotName(DISPLAYED_ITEM);
            }
        }
    }

    private <STACK extends ChemicalStack<?>> void initChemical(IRecipeLayoutBuilder builder, IIngredientType<STACK> type, ChemicalStackIngredient<?, STACK, ?> ingredient) {
        this.initChemical(builder, type, RecipeIngredientRole.INPUT, this.gauge, ingredient.getRepresentations()).setSlotName(CHEMICAL_INPUT);
    }

    private static class OreInfo
    implements GuiChemicalCrystallizer.IOreInfo {
        @Nullable
        private ChemicalCrystallizerRecipe currentRecipe;
        @Nullable
        private ChemicalStack<?> ingredient;
        private ItemStack itemIngredient = ItemStack.EMPTY;

        private OreInfo() {
        }

        @Override
        @NotNull
        public BoxedChemicalStack getInputChemical() {
            if (this.ingredient == null || this.ingredient.isEmpty()) {
                return BoxedChemicalStack.EMPTY;
            }
            return BoxedChemicalStack.box(this.ingredient);
        }

        @Override
        @Nullable
        public ChemicalCrystallizerRecipe getRecipe() {
            return this.currentRecipe;
        }

        @Override
        @NotNull
        public ItemStack getRenderStack() {
            return this.itemIngredient;
        }
    }
}

