/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public abstract class ChemicalChemicalToChemicalRecipeCategory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, ?>>
extends HolderRecipeCategory<RECIPE> {
    protected static final String LEFT_INPUT = "leftInput";
    protected static final String RIGHT_INPUT = "rightInput";
    protected static final String OUTPUT = "output";
    private final IIngredientType<STACK> ingredientType;
    private final GuiGauge<?> leftInputGauge;
    private final GuiGauge<?> rightInputGauge;
    private final GuiGauge<?> outputGauge;
    protected final GuiProgress rightArrow;
    protected final GuiProgress leftArrow;

    protected ChemicalChemicalToChemicalRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<RECIPE> recipeType, IIngredientType<STACK> ingredientType) {
        super(helper, recipeType);
        this.ingredientType = ingredientType;
        this.leftInputGauge = this.addElement(this.getGauge(GaugeType.STANDARD.with(DataType.INPUT_1), 25, 13));
        this.outputGauge = this.addElement(this.getGauge(GaugeType.STANDARD.with(DataType.OUTPUT), 79, 4));
        this.rightInputGauge = this.addElement(this.getGauge(GaugeType.STANDARD.with(DataType.INPUT_2), 133, 13));
        this.addSlot(SlotType.INPUT, 6, 56).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.INPUT_2, 154, 56).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.OUTPUT, 80, 65).with(SlotOverlay.PLUS);
        this.addSlot(SlotType.POWER, 154, 14).with(SlotOverlay.POWER);
        this.rightArrow = this.addConstantProgress(ProgressType.SMALL_RIGHT, 47, 39);
        this.leftArrow = this.addConstantProgress(ProgressType.SMALL_LEFT, 101, 39);
        this.addElement(new GuiHorizontalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 115, 75));
    }

    protected abstract GuiChemicalGauge<CHEMICAL, STACK, ?> getGauge(GaugeType var1, int var2, int var3);

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, RecipeHolder<RECIPE> recipeHolder, @NotNull IFocusGroup focusGroup) {
        ChemicalChemicalToChemicalRecipe recipe = (ChemicalChemicalToChemicalRecipe)recipeHolder.value();
        builder.setShapeless();
        this.initChemical(builder, this.ingredientType, RecipeIngredientRole.INPUT, this.leftInputGauge, ((ChemicalStackIngredient)recipe.getLeftInput()).getRepresentations()).setSlotName(LEFT_INPUT);
        this.initChemical(builder, this.ingredientType, RecipeIngredientRole.INPUT, this.rightInputGauge, ((ChemicalStackIngredient)recipe.getRightInput()).getRepresentations()).setSlotName(RIGHT_INPUT);
        this.initChemical(builder, this.ingredientType, RecipeIngredientRole.OUTPUT, this.outputGauge, recipe.getOutputDefinition()).setSlotName(OUTPUT);
    }
}

